/*
  File: gif2wff.c
  Authors: K.R. Sloan
  Last Modified: 30 May 1990
  Purpose: Convert a GIF format file (.gif) to .WFF format
*/
#include <assert.h>
#include <stdio.h>
#include "wff.h"

static char *RoutineName;
static Usage()
 {
  fprintf( stderr, "Usage: %s gif > wff\n", RoutineName );
  exit(1);
 }

/* global variable interface to gifload.c */
 
extern int GifLoad();
extern unsigned char *Image;
extern unsigned char Red[], Green[], Blue[];
extern int HasColormap, Width, Height;


/* These function deal with WFF files */

static FrameBufferType *SetUpWFFFile(stream, xsize, ysize, Color)
 FILE *stream;
 int xsize, ysize, Color;
 {
  FrameBufferType *FrameBuffer;
  int Bottom, Left, Top, Right;
  int BitsPerBand;
  char WhatBands[10], Name[NameLength], Value[ValueLength];

  FrameBuffer = (FrameBufferType *)0;
  OpenFB(&FrameBuffer);

  assert(FrameBuffer);
  Bottom = 0; Left = 0; Top = ysize-1; Right = xsize-1;
  SetBounds(FrameBuffer, Bottom, Left, Top, Right);

  BitsPerBand = 8;
  if (Color) { strcpy(WhatBands,"RGB"); }
  else       { strcpy(WhatBands,"I");   }
   SetColorSystem(FrameBuffer, WhatBands,  BitsPerBand);

  strcpy(Name,"X-CreatedBy");
  strcpy(Value,RoutineName);
  SetDescriptor(FrameBuffer, Name, Value);

  strcpy(Name,"Encoding");
  strcpy(Value,"AIS");
  SetDescriptor(FrameBuffer, Name, Value);

  /* Header operations over, now we can start the output stream */
  PassImageOut(stream, FrameBuffer);
  return (FrameBuffer);
 }  

static void WriteWFFScanLine(wffdesc, xsize, ScanLine)
 FrameBufferType *wffdesc;
 int xsize;
 unsigned short *ScanLine;
 {
  assert (SUCCESS == NextNPixelsOut(wffdesc, xsize, ScanLine));
 }


static void CloseWFFFile(wffdesc)
 FrameBufferType *wffdesc;
 {
  CloseFB(&wffdesc);
 }

/*
  The Main Line (are we in Philadelphia, yet?)
 */
int
main(argc,argv)
 int argc;
 char *argv[];
 {
  int ArgsParsed = 0;
  char *GifFile;
  FrameBufferType *wffdesc;
  unsigned short *ScanLineOut;
  unsigned char *Iptr;
  int x,y;

  RoutineName = argv[ArgsParsed++];
  if (argc == ArgsParsed)  Usage();
  
  GifFile = argv[ArgsParsed++];
  if (argc != ArgsParsed)  Usage();

  GifLoad(GifFile);

  wffdesc = SetUpWFFFile(stdout, Width, Height, HasColormap);
  assert(wffdesc);

  for(y=0;y<Height;y++)
   {
    unsigned short Pixel[3];
    register unsigned char c;

    Iptr = &Image[(Height-1-y)*Width];
    for(x=0;x<Width;x++)
     {
      c = *(Iptr++);
      if (HasColormap)
       {
        Pixel[0] = (unsigned short)Red[c]; 
        Pixel[1] = (unsigned short)Green[c]; 
        Pixel[2] = (unsigned short)Blue[c]; 
       }
      else
       {
        Pixel[0] = (unsigned short)c;
       }
      NextPixelOut(wffdesc,Pixel);
     }
    wffFlush(wffdesc);
   }
  CloseWFFFile(wffdesc);
  exit(0);
 }
