/*****************************************************************************/
/* module lecture.c							     */
/*									     */
/* Author: Alain Jacot-Descombes					     */
/*	   Labo Image							     */
/*	   Computing Science Center					     */
/*	   University of Geneva, Switzerland				     */
/* Date:   January 1989							     */
/* Modifications:   April 2, 1989: some cleaning.			     */
/* Copyright (c) A. Jacot-Descombes, T. Pun, C. Pellegrini, Uni. of Geneva   */
/* (This copyright notice should appear).				     */
/*									     */
/*****************************************************************************/
#include <suntool/sunview.h>
#include <pixrect/pixrect_hs.h>
#include <suntool/panel.h>
#include <suntool/textsw.h>
#include <stdio.h>
#include <string.h>

#include "define.h"
#include "structure.h"
#include "global.h"
#include "type.h"

extern  Textsw  master;  
extern	char	dirname_in[60], dirname_out[60];
extern  *Histogramme[MAX_IMAGE];

extern int read_desc();  

extern void hproc_acquis_rgb();
extern void hproc_acquis_mel12();
extern void hproc_acquis_mel8();
extern void hproc_acquis_lts();
extern void hproc_acquis_pseudo_std();
extern void hproc_acquis_standard();
extern void hproc_lire_desc();

Frame       frame_lts, frame_fname, rasframe;
Panel       panel_lts, panel_fname, panelras;
Panel_item  fname, dirname, dirnom, filenom;
Panel_item  name_lts, long_header, nbr_ligne, long_ligne, nbr_byte, saut_byte;

static Panel_setting lire_lts();
static Panel_setting lire_fname();


/*****************************************************************************/
/* notify function of fname_panel */

/*****************************************************************************/

static Panel_setting lire_fname (item, event)
    Panel_item item;
    Event *event;

{   
    static struct fname fn;
    char filename[60], *name = (char *) malloc(80);
    int mode;

    if (event_id(event) == CTRLC) {
       /* demande d'interruption de l'interaction par l'utilitsateur */
	flag_break = TRUE;
	window_return (NULL);
	window_destroy (frame_fname);
        return; 
    }
    if (event_id(event) == '\t'){
	return (PANEL_NEXT);
    }
    mode = (int)panel_get(fname, PANEL_CLIENT_DATA);
    strcpy (filename, (char *) panel_get (dirname, PANEL_VALUE));
    if (*filename != '\0'){
	if (mode == 20 || mode == 21) strcpy (dirname_out, filename);
	else strcpy (dirname_in, filename);
	strcat (filename, "/\0");
    }
    strcat (filename, (char *) panel_get (fname, PANEL_VALUE));
    if (flag_creer) strcpy (fn.filename, filename);
    else switch (mode) {
	case 5:
	case 10 : {  /*standard*/
	    if (strcmp(filename, "") == 0){
		fn.fpdesc = NULL;
		fn.fpim = NULL;
		return;
	    }
	    strcpy (name, filename);
	    strcat (name, ".des");
	    if ((fn.fpdesc = fopen (name, "r")) == NULL){
		panel_set_value (fname, "");
		free(name);
		return;

	    }
	    if (mode == 10) {
		strcpy (name, filename);
		strcat (name, ".ima");
		if ((fn.fpim = fopen (name, "r")) == NULL){
		    panel_set_value (fname, "");
		    free(name);
		    return;
		}
	    }
	    strcpy (fn.filename, filename);
	    break;
	}
	case 11 :   /*melanie-8*/
	case 12 : { /*melanie-12*/
	    if (strcmp(filename, "") == 0){
		fn.fpdesc = NULL;
		fn.fpim = NULL;
		return;
	    }
	    strcpy (name, filename);
	    strcat (name, "/f.info");
	    if ((fn.fpdesc = fopen (name, "r")) == NULL){
		panel_set_value (fname, "");
		free(name);
		return;
	    }
	    strcpy (name, filename);
	    if (mode == 11)
		strcat (name, "/image");
	    else
		strcat (name, "/data.ave");
	    if ((fn.fpim = fopen (name, "r")) == NULL){
		panel_set_value (fname, "");
		free(name);
		return;
	    }
	    strcpy (fn.filename, filename);
	    break;
	}
	case 20 : { /* sauvetage image standard */
	    if (strcmp(filename, "") == 0){
		fn.fpdesc = NULL;
		fn.fpim = NULL;
		return;
	    }
	    strcpy (name, filename);
	    strcat (name, ".des");
	    if ((fn.fpdesc = fopen (name, "w")) == NULL){
		panel_set_value (fname, "");
		free(name);
		return;
	    }
	    else{
		strcpy (name, filename);
		strcat (name, ".ima");
		if ((fn.fpim = fopen (name, "w")) == NULL){
		    panel_set_value (fname, "");
		    free(name);
		    return;
		}
		else strcpy (fn.filename, filename);
	    }
	    break; 
	}
	case 21 : { /* sauvetage image laser */
	    if (strcmp(filename, "") == 0){
		fn.fpdesc = NULL;
		fn.fpim = NULL;
		return;
	    }
	    if ((fn.fpim = fopen (filename, "w")) == NULL){
		panel_set_value (fname, "");
		free(name);
		return;
	    }
	    else strcpy (fn.filename, filename);
	    break; 
	}
	case 30 : { /* lecture image raster */
	    if (strcmp(filename, "") == 0){
		fn.fpdesc = NULL;
		fn.fpim = NULL;
		return;
	    }
	    if ((fn.fpim = fopen (filename, "rb")) == NULL){
		panel_set_value (fname, "");
		free(name);
		return;
	    }
	    else strcpy (fn.filename, filename);
	    break; 
	}
	case 31 : { /* sauvetage image raster */
	    if (strcmp(filename, "") == 0){
		fn.fpdesc = NULL;
		fn.fpim = NULL;
		return;
	    }
	    if ((fn.fpim = fopen (filename, "wb")) == NULL){
		panel_set_value (fname, "");
		free(name);
		return;
	    }
	    else strcpy (fn.filename, filename);
	    break; 
	}
	
    }
    window_return (&fn);
    window_destroy (frame_fname);
    return; 
}


/*****************************************************************************/

/* interface to lect_standard */


/*****************************************************************************/

struct fname *fname_panel (titrestr, question, mode)
    char    titrestr[40], question[20];
    int	    mode;
{
    Panel_item	titre;
    struct fname *fn;

    if (descr_file(flag_debug) >= 4) {
    
    frame_fname = window_create(frame, FRAME , WIN_X, 500 , WIN_Y, 500 ,
                              FRAME_NO_CONFIRM, TRUE,  0);
    panel_fname = window_create(frame_fname, PANEL, PANEL_LABEL_BOLD, TRUE, 0);

    titre = panel_create_item (panel_fname, PANEL_MESSAGE,
                       PANEL_SHOW_ITEM, TRUE,
		       PANEL_LABEL_X, ATTR_COL(0),
		       PANEL_LABEL_Y, ATTR_ROW(0),
                       PANEL_LABEL_STRING, titrestr,
                       0);

    dirname = panel_create_item (panel_fname, PANEL_TEXT,
                       PANEL_VALUE_DISPLAY_LENGTH, 40,
                       PANEL_VALUE_STORED_LENGTH, 60,
		       PANEL_LABEL_X, ATTR_COL(1),
		       PANEL_LABEL_Y, ATTR_ROW(2),
                       PANEL_LABEL_STRING,paneltabs[251], 
		       PANEL_VALUE, "",
                       PANEL_NOTIFY_STRING, "\n\r\t\03",
                       PANEL_NOTIFY_PROC, lire_fname, 0);
    if (mode == 20 || mode == 21) panel_set_value (dirname, dirname_out);
    else panel_set_value (dirname, dirname_in);
    fname = panel_create_item (panel_fname, PANEL_TEXT,
                       PANEL_VALUE_DISPLAY_LENGTH, 40,
                       PANEL_VALUE_STORED_LENGTH, 60,
		       PANEL_LABEL_X, ATTR_COL(1),
		       PANEL_LABEL_Y, ATTR_ROW(3),
                       PANEL_LABEL_STRING, paneltabs[252],
		       PANEL_VALUE, "",
		       PANEL_CLIENT_DATA, mode,
                       PANEL_NOTIFY_STRING, "\n\r\t\03",
                       PANEL_NOTIFY_PROC, lire_fname, 0);
    if (flag_exec == MANUEL || flag_exec == FROMTO_AUTO){
	if (macro_cour->code == 32) /* HISTPS */
	    panel_set_value (fname, 
		((struct histogr *)((struct description_vecteur *)
		macro_cour->param)->prive)->fileps->filename);
	else
	    panel_set_value (fname, ((struct fname *)macro_cour->param)->filename);
    }
    window_fit (panel_fname);
    window_fit (frame_fname);

    window_set (panel_fname, PANEL_CARET_ITEM, fname, 0);
    fn = (struct fname *)window_loop(frame_fname); 
    return (fn);
    }
    else {
	flag_break = TRUE;
	write_erreur(30);
    }
}


/*****************************************************************************/
/*                							     */
/* nom      : lire_plan_image 						     */
/*									     */
/* fonction : lit un plan-image d'une image standard stockee dans le         */
/*	      fichier fp.						     */
/*									     */
/* entrees  : int indice		: (indice)eme plan d'une image       */
/*	      int index                 : indice de stockage dans	     */
/*					  dir_image et dir_desc		     */
/*	      int taille		: taille en bytes du plan-image      */
/*	      FILE *fp			: fichier contenant l'image	     */
/*									     */
/* globales : desc			: descripteur de fichier image       */
/*									     */
/* return   : neant                                                          */
/*								             */
/* routines : neant							     */
/*								             */
/*****************************************************************************/

void lire_plan_image (indice, index, taille, fn)
    int indice, index, taille;
    struct fname *fn;
{
    unsigned char *image;
    int k;

    image = (unsigned char *)malloc(taille);
    if (image == NULL) {
	    sprintf(buf, "no memory !!!\n");
	    write_master(buf);
    }
    k = fread (image, taille, 1, fn->fpim);
    if (dir_image[index].image != NULL)
        free (dir_image[index].image);
    dir_image[index].image = image;
    strcpy (dir_desc[index].date, desc.date);       
    strcpy (dir_desc[index].comment, desc.comment); 
    strcpy (dir_desc[index].filename, fn->filename);
    dir_desc[index].type = desc.type;
        /* desc.type a ete prepare pour l'appel a cette procedure */
    dir_desc[index].ncolonne = desc.ncolonne;
    dir_desc[index].nligne = desc.nligne;
    dir_desc[index].mmin = desc.mini[indice];
    dir_desc[index].mmax = desc.maxi[indice];
    dir_desc[index].mu = desc.mu[indice];
    dir_desc[index].ecart = desc.ecart[indice];
    if (Histogramme[index] != NULL)
	free(Histogramme[index]);
    Histogramme[index] = NULL;
}

/* ***************************************************************************
To read old descriptor...
*************************************************************************** */
 
int lecture_descripteur (fn)
    struct  fname   *fn;
{
    Frame   finfo;
    Textsw  tinfo;
    char    *buf, *line;
    struct  description	desc;
    int j;

    finfo = window_create(NULL, FRAME, FRAME_NO_CONFIRM, TRUE,
			  FRAME_LABEL, fn->filename,
			  0, 0);
    tinfo = window_create (finfo, TEXTSW,
			  WIN_WIDTH, 400, WIN_HEIGHT, 240, 
                          TEXTSW_SCROLLBAR, NULL, 
                          TEXTSW_IGNORE_LIMIT, TEXTSW_INFINITY, 0);

    window_fit (finfo);

    buf = (char *) malloc (500);
    line = (char *) malloc (80);
/* OLD DESCRIPTOR......
    fread (&desc, sizeof(desc), 1, fn->fpdesc); 
*/
    j = read_desc(fn->fpdesc, &desc);
    switch (j){
	case -1: write_erreur(104);
		   return;
	case 0: write_erreur(103);
		   return;
    }

    strcpy (buf, "\n\0");
    strcat (buf, sprintf (line, "   type    : %d\n\0", desc.type));
    strcat (buf, sprintf (line, "   nligne  : %d\n\0", desc.nligne));
    strcat (buf, sprintf (line, "   ncolonne: %d\n\0", desc.ncolonne));
    strcat (buf, sprintf (line, "   date    : %s\n\0", desc.date));
    strcat (buf, sprintf (line, "   maxi[6] : %11.5f %11.5f %11.5f\n",
	desc.maxi[0], desc.maxi[1], desc.maxi[2]));
    strcat (buf, sprintf (line, "           : %11.5f %11.5f %11.5f\n",
	desc.maxi[3], desc.maxi[4], desc.maxi[5]));
    strcat (buf, sprintf (line, "   mini[6] : %11.5f %11.5f %11.5f\n",
	desc.mini[0], desc.mini[1], desc.mini[2]));
    strcat (buf, sprintf (line, "           : %11.5f %11.5f %11.5f\n",
	desc.mini[3], desc.mini[4], desc.mini[5]));
    strcat (buf, sprintf (line, "   mu[6]   : %11.5f %11.5f %11.5f\n",
	desc.mu[0], desc.mu[1], desc.mu[2]));
    strcat (buf, sprintf (line, "           : %11.5f %11.5f %11.5f\n",
	desc.mu[3], desc.mu[4], desc.mu[5]));
    strcat (buf, sprintf (line, "   ecart[6]: %11.5f %11.5f %11.5f\n",
	desc.ecart[0], desc.ecart[1], desc.ecart[2]));
    strcat (buf, sprintf (line, "           : %11.5f %11.5f %11.5f\n",
	desc.ecart[3], desc.ecart[4], desc.ecart[5]));

    textsw_insert (tinfo, buf, strlen(buf));
    window_set (tinfo, TEXTSW_READ_ONLY, TRUE, 0);
    free (buf);
    window_set (finfo, WIN_SHOW, TRUE, 0);
}

/* ***************************************************************************
To read old descriptor...
 *************************************************************************** */

caddr_t proc_lire_desc( m, mi)
    Menu m;
    Menu_item mi;
{
    struct fname *fn;

    if (flag_bother){
	 hproc_lire_desc();
	 return;
    }
    if (flag_help) hproc_lire_desc();
    sprintf (buf, mastertabs[131]);
    write_master (buf);
    fn = fname_panel("LECTURE DESCRIPTEUR", "nom du fichier\0", 5);
    if (flag_break) interruption();
    else {
	strcpy (buf, strcat(fn->filename, ".desc\n"));
	write_master (buf);
	sprintf (buf, fn->filename);
        lecture_descripteur(fn);
	fclose (fn->fpdesc);
    }
return;
}




/*****************************************************************************/



/*****************************************************************************/ 


int lecture_standard (fn, fflag)
    struct  fname   *fn; 
    int fflag;
{
    int     n,taille,elem, p, k;
    FILE  *fp;
    char filedesc[80];
    char *pdate;

    /* lecture du descripteur */

/* OLD DESCRIPTOR
    k = fread(&desc,sizeof(desc),1,fn->fpdesc);
*/
    k = read_desc(fn->fpdesc, &desc);
    switch (k){
	case -1: write_erreur(104);
		   return;
	case 0: write_erreur(103);
		   return;
    }

    if (desc.type < 4) elem = element (desc.type);
    else {
	switch (desc.type) {
	    case 4 :
            case 5 : elem = 4; break;
            case 6 : elem = 1; break;
	    }
	}
    taille = desc.nligne * desc.ncolonne * elem;

    if (flag_exec == AUTO || flag_exec == FROMTO_AUTO){
	index_image[0] = macro_cour->from[0];
	index_image[2] = macro_cour->from[1];
	index_image[4] = macro_cour->from[2];
	index_image[6] = macro_cour->from[3];
	index_image[1] = macro_cour->to[0];
	index_image[3] = macro_cour->to[1];
	index_image[5] = macro_cour->to[2];
	index_image[7] = macro_cour->to[3];
    }

    switch (desc.type) {
	case -1:
        case 0 :
        case 1 :
        case 2 :
        case 3 :
	    if (flag_exec != AUTO && flag_exec != FROMTO_AUTO)
		fromto (TO, DEFAUT);
	    if (flag_break){
		interruption();
		return;
	    }
            sprintf (buf, mastertabs[132], fn->filename, index_image[1]);
            write_master (buf);
            lire_plan_image (0, index_image[1], taille, fn);

            if (fflag) statis ( dir_image[index_image[1]].image, 
				dir_desc[index_image[1]].type, 
				dir_desc[index_image[1]].nligne,
				dir_desc[index_image[1]].ncolonne,
				&(dir_desc[index_image[1]].mmin), 
				&(dir_desc[index_image[1]].mmax), 
				&(dir_desc[index_image[1]].mu), 
				&(dir_desc[index_image[1]].ecart));
            break;
        case 4 : 
        case 5 : 
            if (desc.type == 4) {
		if (flag_exec != AUTO && flag_exec != FROMTO_AUTO)
		    fromto (TO, COMPL1); 
	    }
            else { 
		if (flag_exec != AUTO && flag_exec != FROMTO_AUTO)
		    fromto (TO, COMPL2);
	    } 
	    if (flag_break){
		interruption();
		return;
	    }
            sprintf (buf, mastertabs[133], fn->filename, index_image[1], index_image[3]);
            write_master (buf);
            desc.type = 3;     /* les 2 plans-image sont des float */ 
            lire_plan_image (0, index_image[1], taille, fn);
            lire_plan_image (1, index_image[3], taille, fn);
	    if (fflag){
               statis (dir_image[index_image[1]].image, 
                     dir_desc[index_image[1]].type, 
	             dir_desc[index_image[1]].nligne, 
                     dir_desc[index_image[1]].ncolonne,
                     &(dir_desc[index_image[1]].mmin), 
                     &(dir_desc[index_image[1]].mmax), 
	             &(dir_desc[index_image[1]].mu), 
                     &(dir_desc[index_image[1]].ecart));

               statis (dir_image[index_image[3]].image, 
                    dir_desc[index_image[3]].type, 
	            dir_desc[index_image[3]].nligne,
                    dir_desc[index_image[3]].ncolonne,
                    &(dir_desc[index_image[3]].mmin), 
                    &(dir_desc[index_image[3]].mmax), 
	            &(dir_desc[index_image[3]].mu), 
                    &(dir_desc[index_image[3]].ecart));
	    }
            break;
        case 6 : 
	    if (flag_exec != AUTO && flag_exec != FROMTO_AUTO)
		fromto (TO, RGB);
	    if (flag_break){
		interruption();
		return;
	    }
            sprintf (buf,mastertabs[134],fn->filename,index_image[1],
		     index_image[3],index_image[5]);
            write_master (buf);
            desc.type = 0;     /* les 3 plans-image sont des bytes */
            lire_plan_image (0, index_image[1], taille, fn);
            lire_plan_image (1, index_image[3], taille, fn);
            lire_plan_image (2, index_image[5], taille, fn);
	    if (fflag){
		statis (dir_image[index_image[1]].image, 
                     dir_desc[index_image[1]].type, 
	             dir_desc[index_image[1]].nligne, 
                     dir_desc[index_image[1]].ncolonne,
                     &(dir_desc[index_image[1]].mmin), 
                     &(dir_desc[index_image[1]].mmax), 
	             &(dir_desc[index_image[1]].mu), 
                     &(dir_desc[index_image[1]].ecart));
		statis (dir_image[index_image[3]].image, 
                    dir_desc[index_image[3]].type, 
	            dir_desc[index_image[3]].nligne,
                    dir_desc[index_image[3]].ncolonne,
                    &(dir_desc[index_image[3]].mmin), 
                    &(dir_desc[index_image[3]].mmax), 
	            &(dir_desc[index_image[3]].mu), 
                    &(dir_desc[index_image[3]].ecart));
		statis (dir_image[index_image[5]].image, 
                    dir_desc[index_image[5]].type, 
	            dir_desc[index_image[5]].nligne,
                    dir_desc[index_image[5]].ncolonne,
                    &(dir_desc[index_image[5]].mmin), 
                    &(dir_desc[index_image[5]].mmax), 
	            &(dir_desc[index_image[5]].mu), 
                    &(dir_desc[index_image[5]].ecart));
	    }
            break;
    }

    fclose (fn->fpim);
    fclose(fn->fpdesc);

    if (fflag){
	desc.mini[0]=dir_desc[index_image[1]].mmin;
	desc.maxi[0]=dir_desc[index_image[1]].mmax;
	desc.mu[0]=dir_desc[index_image[1]].mu;
	desc.ecart[0]=dir_desc[index_image[1]].ecart;
	if (desc.type > 3){
	    desc.mini[1]=dir_desc[index_image[3]].mmin;
	    desc.maxi[1]=dir_desc[index_image[3]].mmax;
	    desc.mu[1]=dir_desc[index_image[3]].mu;
	    desc.ecart[1]=dir_desc[index_image[3]].ecart;
	}
	else desc.mini[1]=desc.maxi[1]=desc.mu[1]=desc.ecart[1]=0;
	if (desc.type > 5){
	    desc.mini[2]=dir_desc[index_image[5]].mmin;
	    desc.maxi[2]=dir_desc[index_image[5]].mmax;
	    desc.mu[2]=dir_desc[index_image[5]].mu;
	    desc.ecart[2]=dir_desc[index_image[5]].ecart;
	}
	else desc.mini[2]=desc.maxi[2]=desc.mu[2]=desc.ecart[2]=0;
	desc.mini[3]=desc.maxi[3]=desc.mu[3]=desc.ecart[3]=0;
	desc.mini[4]=desc.maxi[4]=desc.mu[4]=desc.ecart[4]=0;
	desc.mini[5]=desc.maxi[5]=desc.mu[5]=desc.ecart[5]=0;
        strcpy (desc.comment, dir_desc[index_image[1]].comment);

	if (dir_desc[index_image[1]].date[0] == '\0'){
	    strcpy (desc.date, (char *)get_time());
	}
	else{
	    pdate = dir_desc[index_image[1]].date;
	    while (*pdate == ' ') pdate++;
	    strcpy (desc.date, pdate);
	}
	strcpy(filedesc,fn->filename);
	strcat(filedesc,".des");

	fp = fopen(filedesc, "w");
/* OLD DESCRIPTOR
	k = fwrite(&desc, sizeof(desc),1,fp);
*/	
	write_desc(fp, desc);
	fclose (fp); 
    }

}
/*****************************************************************************/

/* nom      : proc_lecture_standard					     */
/*									     */
/* fonction : lit une image en format standard (.ima et .des) 
              ou bien lit une image en format standard (.ima et .des)
               dont le descripteur n'est pas mis au jour, donc a la fin
              de la lecture ceci se fait automatiquement.                    */

/* entrees  : char *filnam            : nom du fichier d'entree              */

/* globales : int index_image[6]					     */
/*	      char *buf							     */

/* return   : FALSE si il y a un probleme                                    */
/*          : TRUE si la lecture s'est faite correctement		     */

/* routines : fromto					                     */
/*	      write_master						     */
/*	      lire_plan_image						     */
/*****************************************************************************/
 
caddr_t proc_lecture_standard(m, mi)
    Menu m;
    Menu_item mi;

{

    struct fname *fn, *copyfn;
    int flag, menuval,i, desccheck;

  menuval = (int) menu_get (mi, MENU_VALUE);
    switch (menuval){
	case 1: flag = TRUE;
		break;
	case 0: flag = FALSE;
		break;
    }
    if (flag_bother){
        if (flag) hproc_acquis_pseudo_std();	
	else  hproc_acquis_standard();
	 return;
    }

    if (flag_help){
        if (flag) hproc_acquis_pseudo_std();	 
	else  hproc_acquis_standard();
    }

    if (!flag_creer) {
        if (flag) sprintf (buf, mastertabs[135]);
	else sprintf (buf, mastertabs[136]);
	write_master (buf);
    }
    if (flag_exec == AUTO || flag_exec == PARAM_AUTO){
	char *filen;
	filen = (char *)malloc(60);
	fn = (struct fname *)macro_cour->param;
	fn->fpim = fopen (sprintf(filen,"%s.ima",fn->filename), "r"); 
	fn->fpdesc = fopen (sprintf(filen,"%s.des",fn->filename), "r"); 
    }
    else{
	if (flag) fn = fname_panel(paneltabs[253], paneltabs[252], 10);
        else fn = fname_panel(paneltabs[254], paneltabs[252], 10);
         }
         
    if (flag_break) {
      interruption();
      return;
    }
    else {

	if (flag_creer){
	    struct commande *com;
	    char filename[60];
	    strcpy (filename, fn->filename);
	    strcat (filename, ".des");
	    if ((fn->fpdesc = fopen(filename, "r")) != NULL){
/*OLD DESCRIPTOR
	    fread (&desc, sizeof(desc), 1, fn->fpdesc); 
*/
	    desccheck = read_desc(fn->fpdesc, &desc);
	    switch (desccheck){
		case -1: write_erreur(104);
			return;
		case 0: write_erreur(103);
			return;
	    }	
		fclose (fn->fpdesc);
	    }
	    else desc.type = 6;
	    switch (desc.type){
		case -1:
		case 0:
		case 1:
		case 2:
		case 3:
		    fromto (TO, DEFAUT);
		    if (flag_break){
			interruption();
			return;
		    }
		    com = (struct commande *)new_commande (&macro_cour);
		    com->to[0] = index_image[1];
		    if (flag){
			com->code = -1;
			sprintf (com->nom, "I_OLIMPST\0"); 
			sprintf (buf, "I_OLIMPST TO %d WITH %s\n\0",
				 index_image[1], fn->filename);
		    }
		    else {
			com->code = 1;
			sprintf (com->nom, "I_OLIMSTD\0"); 
			sprintf (buf, "I_OLIMSTD TO %d WITH %s\n\0",
				 index_image[1], fn->filename);
		    }

		    break;
		case 4:
		    fromto (TO, COMPL1);
		    if (flag_break){
			interruption();
			return;
		    }
		    com = (struct commande *)new_commande (&macro_cour);
		    com->to[0] = index_image[1];
		    com->to[1] = index_image[3];
		    if (flag){
			com->code = -1;
			sprintf (com->nom, "I_OLIMPST\0"); 
			sprintf (buf, "I_OLIMPST TO %d %d WITH %s\n\0", 
				index_image[1], index_image[3], fn->filename);
		    }
		    else{
			com->code = 1;
			sprintf (com->nom, "I_OLIMSTD\0"); 
			sprintf (buf, "I_OLIMSTD TO %d %d WITH %s\n\0", 
				index_image[1], index_image[3], fn->filename);
		    }
		    break;
		case 5:
		    fromto (TO, COMPL2);
		    if (flag_break){
			interruption();
			return;
		    }
		    com = (struct commande *)new_commande (&macro_cour);
		    com->to[0] = index_image[1];
		    com->to[1] = index_image[3];
		    if (flag){
			com->code = -1;
			sprintf (com->nom, "I_OLIMPST\0"); 
			sprintf (buf, "I_OLIMPST TO %d %d WITH %s\n\0", 
				index_image[1], index_image[3], fn->filename);
		    }
		    else{
			com->code = 1;
			sprintf (com->nom, "I_OLIMSTD\0"); 
			sprintf (buf, "I_OLIMSTD TO %d %d WITH %s\n\0", 
				index_image[1], index_image[3], fn->filename);
		    }
		    break;
		case 6:
		    fromto (TO, RGB);
		    if (flag_break){
			interruption();
			return;
		    }
		    com = (struct commande *)new_commande (&macro_cour);
		    com->to[0] = index_image[1];
		    com->to[1] = index_image[3];
		    com->to[2] = index_image[5];
		    if (flag){
		      com->code = -1;
		      sprintf (com->nom, "I_OLIMPST\0"); 
		      sprintf (buf, "I_OLIMPST TO %d %d %d WITH %s\n\0", 
			index_image[1], index_image[3], index_image[5],
			fn->filename);
		    }
		    else{
		      com->code = 1;
		      sprintf (com->nom, "I_OLIMSTD\0"); 
		      sprintf (buf, "I_OLIMSTD TO %d %d %d WITH %s\n\0", 
			index_image[1], index_image[3], index_image[5],
			fn->filename);	
		    }
		    
		    break;
	    }
	    write_macro (buf);
	    fn->fpim = fn->fpdesc = NULL;
	    copyfn = (struct fname *)malloc(sizeof(*copyfn));
	    *copyfn = *fn;
	    com->param = (char *)copyfn;
	}
        else{
	    if (fn->fpdesc != NULL && fn->fpim != NULL){
		 lecture_standard(fn, flag);
                i=i+1;  
		descr_file (flag_debug);
	    }
	    else write_erreur (20);
	}
    }
 return;
}

/*****************************************************************************/
/* function which reads a raster file and stores the  image
   onto a memory plane */

/*****************************************************************************/
caddr_t proc_read_rasterfile(m, mi)
    Menu m;
    Menu_item mi;
{
    FILE *fp, *fpm;
    char *frdesname,desname[60], imname[60], mapname[60];
    struct fname *fnras, *copyfnras;
    struct pixrect *ppixrect;
    struct mpr_data *pr_data;
    colormap_t colormaploc;
    unsigned char map[3] [256];
    struct description descy;
    unsigned char *imageraster;
    struct commande *com;
    char filename[60];
    
   if (flag_bother){
       hproc_read_rasterfile();
       return;
   }
   if (flag_help) hproc_read_rasterfile();
   if (!flag_creer){
       sprintf (buf, mastertabs[137]);
       write_master(buf);
   }
   if ((flag_exec == AUTO) || (flag_exec == PARAM_AUTO)){
       char *filen;
	filen = (char *)malloc(60);
	fnras = (struct fname *)macro_cour->param;
	fnras->fpim = fopen (sprintf(filen,"%s",fnras->filename), "rb"); 
   }
   else fnras =fname_panel(paneltabs[255], paneltabs[252], 30);
   if (flag_break) {
      interruption();
       return; 
   }
   if (flag_creer){
	fromto (TO, DEFAUT);
	if (flag_break){
	    interruption();
	     return; 
	}
       com = (struct commande *)new_commande (&macro_cour);
       com->to[0] = index_image[1];
       com->code = 6;
       sprintf (com->nom, "I_OLIMSRA\0"); 
       sprintf (buf, "I_OLIMSRA TO %d WITH %s\n\0", 
		index_image[1], fnras->filename);
       write_macro (buf);
       fnras->fpim = fnras->fpdesc = NULL; 
       copyfnras = (struct fname *)malloc(sizeof(*copyfnras));
       *copyfnras = *fnras;
       com->param = (char *)copyfnras;
   }
   else {
       if (flag_exec == AUTO || flag_exec == FROMTO_AUTO)
	    index_image[1] = macro_cour->to[0];
       else fromto (TO, DEFAUT);
       if (flag_break){
	    interruption();
	    return;
       }
       colormaploc.map[0] = map[0];
	colormaploc.map[1] = map[1];
	colormaploc.map[2] = map[2];
	ppixrect = pr_load(fnras->fpim, &colormaploc);
	fclose(fnras->fpim); 
	if (ppixrect == NULL){
	    sprintf(buf, mastertabs[146]);
	    write_master(buf);
	    return;
	}
	if (ppixrect->pr_depth != 8){
	    sprintf(buf, mastertabs[147]);
	    write_master(buf);
	    return;
	}
	else descy.type = 0;
	descy.nligne = ppixrect->pr_size.y;
	descy.ncolonne = ppixrect->pr_size.x;
	strcpy(descy.comment,"");
	strcpy(descy.date,"");
	pr_data = mpr_d(ppixrect);
	strcpy(imname, fnras->filename);
	strcat(imname, ".");
	frdesname = strtok(imname, ".");
	sprintf(mapname, "%s.map", frdesname);
	sprintf(desname, "%s.des", frdesname);
	sprintf(imname, "%s.ima", frdesname);
	fpm = fopen(mapname , "wb");
	fwrite(colormaploc.map[0], 256, 1, fpm); 
	fwrite(colormaploc.map[1], 256, 1, fpm); 
	fwrite(colormaploc.map[2], 256, 1, fpm); 
	fclose(fpm);
   
	imageraster =(unsigned char *) malloc(descy.nligne *descy.ncolonne * sizeof(unsigned char));
	if (!(descy.ncolonne & 0x01)) 
		memcpy(imageraster,pr_data->md_image,
		descy.nligne * descy.ncolonne * sizeof(unsigned char));
	else
	{
		int y;
		unsigned char *Adrs=(unsigned char *)pr_data->md_image, *Adrd=imageraster;
		for (y = 0 ; y < descy.nligne ; y++ , Adrd += descy.ncolonne ,Adrs += descy.ncolonne+1)
		 memcpy(Adrd, Adrs, descy.ncolonne);
	} 
	pr_destroy(ppixrect);
	fp = fopen(imname, "wb");
	fwrite(imageraster, descy.ncolonne, descy.nligne, fp);
	fclose(fp);
	sprintf(buf," %s --> %d\n", fnras->filename, index_image[1]);
	write_master(buf);
	if (dir_image[index_image[1]].image != NULL)
		free (dir_image[index_image[1]].image);
	dir_image[index_image[1]].image = (unsigned char *)imageraster;
	strcpy (dir_desc[index_image[1]].date, descy.date);       
	strcpy (dir_desc[index_image[1]].filename, imname);
	dir_desc[index_image[1]].type = descy.type;
	dir_desc[index_image[1]].ncolonne = descy.ncolonne;
	dir_desc[index_image[1]].nligne = descy.nligne;
	dir_desc[index_image[1]].mmin = descy.mini[0];
	dir_desc[index_image[1]].mmax = descy.maxi[0];
	dir_desc[index_image[1]].mu = descy.mu[0];
	dir_desc[index_image[1]].ecart = descy.ecart[0];
	statis (dir_image[index_image[1]].image, 
		dir_desc[index_image[1]].type, 
		dir_desc[index_image[1]].nligne, 
		dir_desc[index_image[1]].ncolonne,
		&(dir_desc[index_image[1]].mmin), 
		&(dir_desc[index_image[1]].mmax), 
		&(dir_desc[index_image[1]].mu), 
		&(dir_desc[index_image[1]].ecart));
	descy.mini[0]=dir_desc[index_image[1]].mmin;
	descy.maxi[0]=dir_desc[index_image[1]].mmax;
	descy.mu[0]=dir_desc[index_image[1]].mu;
	descy.ecart[0]=dir_desc[index_image[1]].ecart;
	descy.mini[1]=descy.maxi[1]=descy.mu[1]=descy.ecart[1]=0;
	descy.mini[2]=descy.maxi[2]=descy.mu[2]=descy.ecart[2]=0;
	descy.mini[3]=descy.maxi[3]=descy.mu[3]=descy.ecart[3]=0;
	descy.mini[4]=descy.maxi[4]=descy.mu[4]=descy.ecart[4]=0;
	descy.mini[5]=descy.maxi[5]=descy.mu[5]=descy.ecart[5]=0;

	fp = fopen(desname, "w");
	if (fp == NULL){
	    write_erreur(40);
	    return;
	}
/* OLD DESCRIPTOR
	if (fwrite(&descy, sizeof(descy), 1, fp) != 1){
*/
	if (write_desc(fp, descy) != 1){
	    write_erreur(40);
	    return;
	}
	fclose(fp);

   }
   
} 


/*****************************************************************************/
/* nom      : lire_lts							     */
/*									     */
/* fonction : lit le nom du fichier d'entree dans un panneau pour des        */
/*	      images de type LTS.					     */
/*                                                                           */
/* entrees  : panel_item item		: item d'interaction	             */
/*            Event event	        : evenements		             */
/*                                                                           */
/* globales : Frame frame_lts		: frame du panneau d'interaction     */
/*	      Panel_item name_lts	: item demandant le nom du fichier   */
/*	      Textsw  master		: fenetre de commandes		     */
/*									     */
/* return   : neant                                     		     */
/*									     */
/* routines : neant							     */
/*									     */
/*****************************************************************************/

static Panel_setting lire_lts (item, event)
    Panel_item item;
    Event *event;

{   
    static struct lecture_lts lect_lts;
    char filename[60];

    if (event_id(event) == CTRLC) {
        /* demande d'interruption de l'interaction par l'utilitsateur */
	flag_break = TRUE;
	window_return (NULL);
	window_destroy (frame_lts);
        return;
    }
    if (item == name_lts) {
	strcpy (filename, (char *) panel_get (item, PANEL_VALUE));
	if (!flag_creer)
	    if ((lect_lts.fp_lts = fopen (filename, "r")) == NULL) {
		panel_set_value (name_lts, "\0");
		return;
	    }
	    else strcpy (lect_lts.filename, filename);
	else strcpy (lect_lts.filename, filename);
    }
    if (event_id(event) == '\t') {
	if (item == saut_byte)
	    window_set (panel_lts, PANEL_CARET_ITEM, name_lts, 0);
	return (PANEL_NEXT);
    }
    else {
	lect_lts.header = atoi((char *)panel_get (long_header, PANEL_VALUE));
	lect_lts.nlignes = atoi((char *)panel_get (nbr_ligne,  PANEL_VALUE));
	lect_lts.nbytes = atoi((char *)panel_get (long_ligne, PANEL_VALUE));
	lect_lts.nvaleur = atoi((char *)panel_get (nbr_byte, PANEL_VALUE));
	lect_lts.bytes_sautes = atoi((char *)panel_get(saut_byte,PANEL_VALUE));
	window_return (&lect_lts);
	window_destroy (frame_lts);
	return;
    }
}


/*****************************************************************************/
/*                							     */
/* nom      : lire_filelts 						     */
/*									     */
/* fonction : lit dans le fichier fp_lts une image stockee selon le format   */
/*	      du "laboratoire de traitement des signaux".		     */
/*									     */
/* entrees  : neant						             */
/*									     */
/* globales : dir_image					                     */
/*									     */
/* return   : neant                                                          */
/*								             */
/* routines : statis							     */
/*								             */
/*****************************************************************************/

int lire_filelts(noarr, info)

int	noarr;
struct	lecture_lts *info;

{
    int taille;
    register int i, j;
    unsigned char *im;

    fseek (info->fp_lts, (long)(info->header), 0);
    taille = info->nlignes * info->nvaleur;
    im = (unsigned char *) malloc (taille);
    if (dir_image[noarr].image != NULL) free (dir_image[noarr].image);
    dir_image[noarr].image = (unsigned char *)im;
    for (j=0; j<info->nlignes; j++) {
	for (i=0; i<info->nvaleur; i++) {
	    fseek (info->fp_lts, (long)(info->bytes_sautes), 1);
	    fread (im, sizeof(*im), 1, info->fp_lts);
            im++;
	}
        fseek (info->fp_lts, (long)(info->nbytes - 
			      info->nvaleur * (info->bytes_sautes + 1)), 1);
    }
    fclose (info->fp_lts);
    dir_desc[noarr].type = 0;
    dir_desc[noarr].nligne = info->nlignes;
    dir_desc[noarr].ncolonne = info->nvaleur;
    strcpy (dir_desc[noarr].date, (char *) get_time());	    /* date et heure */
    strcpy (dir_desc[noarr].filename, info->filename);	    /* nom fichier */
    statis (dir_image[noarr].image, dir_desc[noarr].type, 
	    dir_desc[noarr].nligne, dir_desc[noarr].ncolonne,
            &(dir_desc[noarr].mmin), &(dir_desc[noarr].mmax), 
	    &(dir_desc[noarr].mu), &(dir_desc[noarr].ecart));
    if (Histogramme[noarr] != NULL)
	free(Histogramme[noarr]);
    Histogramme[noarr] = NULL;
    return;
}


/*****************************************************************************/

struct lecture_lts *lts_panel (titrestr)
    char titrestr[40];
{
    Panel_item	titre;
    char rep[20];
    struct lecture_lts *lect_lts;

    frame_lts = window_create(frame, FRAME , WIN_X, 500 , WIN_Y, 500 ,
                              FRAME_NO_CONFIRM, TRUE,  0);
    panel_lts = window_create(frame_lts, PANEL, PANEL_LABEL_BOLD, TRUE, 0);

    titre = panel_create_item (panel_lts, PANEL_MESSAGE,
                       PANEL_SHOW_ITEM, TRUE,
		       PANEL_LABEL_X, ATTR_COL(0),
		       PANEL_LABEL_Y, ATTR_ROW(0),
                       PANEL_LABEL_STRING, titrestr,
                       0);

    name_lts = panel_create_item (panel_lts, PANEL_TEXT,
                       PANEL_VALUE_DISPLAY_LENGTH, 30,
                       PANEL_VALUE_STORED_LENGTH, 60,
		       PANEL_LABEL_X, ATTR_COL(1),
		       PANEL_LABEL_Y, ATTR_ROW(2),
                       PANEL_LABEL_STRING, paneltabs[252],
		       PANEL_VALUE, "\0",
                       PANEL_NOTIFY_STRING, "\n\r\t\03",
                       PANEL_NOTIFY_PROC, lire_lts, 0);
  
    long_header = panel_create_item (panel_lts, PANEL_TEXT,
                       PANEL_SHOW_ITEM, TRUE, 
                       PANEL_VALUE_DISPLAY_LENGTH, 30,
                       PANEL_VALUE_STORED_LENGTH, 30,
		       PANEL_LABEL_X, ATTR_COL(1),
		       PANEL_LABEL_Y, ATTR_ROW(3),
                       PANEL_LABEL_STRING, paneltabs[256],
		       PANEL_VALUE, "\0",
                       PANEL_NOTIFY_STRING, "\n\r\t\03",
                       PANEL_NOTIFY_PROC, lire_lts, 0);

    nbr_ligne= panel_create_item (panel_lts, PANEL_TEXT,
                       PANEL_SHOW_ITEM, TRUE, 
                       PANEL_VALUE_DISPLAY_LENGTH, 30,
                       PANEL_VALUE_STORED_LENGTH, 30,
		       PANEL_LABEL_X, ATTR_COL(1),
		       PANEL_LABEL_Y, ATTR_ROW(4),
                       PANEL_LABEL_STRING, paneltabs[257],
		       PANEL_VALUE, "\0",
                       PANEL_NOTIFY_STRING, "\n\r\t\03",
                       PANEL_NOTIFY_PROC, lire_lts, 0);

    long_ligne = panel_create_item (panel_lts, PANEL_TEXT,
                       PANEL_SHOW_ITEM, TRUE, 
                       PANEL_VALUE_DISPLAY_LENGTH, 30,
                       PANEL_VALUE_STORED_LENGTH, 30,
		       PANEL_LABEL_X, ATTR_COL(1),
		       PANEL_LABEL_Y, ATTR_ROW(5),
                       PANEL_LABEL_STRING, paneltabs[258],
		       PANEL_VALUE, "\0",
                       PANEL_NOTIFY_STRING, "\n\r\t\03",
                       PANEL_NOTIFY_PROC, lire_lts, 0);

    nbr_byte = panel_create_item (panel_lts, PANEL_TEXT,
                       PANEL_SHOW_ITEM, TRUE, 
                       PANEL_VALUE_DISPLAY_LENGTH, 30,
                       PANEL_VALUE_STORED_LENGTH, 30,
		       PANEL_LABEL_X, ATTR_COL(1),
		       PANEL_LABEL_Y, ATTR_ROW(6),
                       PANEL_LABEL_STRING, paneltabs[259],
		       PANEL_VALUE, "\0",
                       PANEL_NOTIFY_STRING, "\n\r\t\03",
                       PANEL_NOTIFY_PROC, lire_lts, 0);

    saut_byte = panel_create_item (panel_lts, PANEL_TEXT,
                       PANEL_SHOW_ITEM, TRUE, 
                       PANEL_VALUE_DISPLAY_LENGTH, 30,
                       PANEL_VALUE_STORED_LENGTH, 30,
		       PANEL_LABEL_X, ATTR_COL(1),
		       PANEL_LABEL_Y, ATTR_ROW(7),
                       PANEL_LABEL_STRING,paneltabs[260],
                           
		       PANEL_VALUE, "\0",
                       PANEL_NOTIFY_STRING, "\n\r\t\03",
                       PANEL_NOTIFY_PROC, lire_lts, 0);
    if (flag_exec == MANUEL || flag_exec == FROMTO_AUTO){
	struct lecture_lts *lect_lts;
	char *t;
	t = (char *)malloc(10);
	lect_lts = (struct lecture_lts *)macro_cour->param;
	panel_set_value (name_lts, lect_lts->filename);
	panel_set_value (long_header,sprintf(t,"%d\0",lect_lts->header));
	panel_set_value (nbr_ligne, sprintf(t,"%d\0",lect_lts->nlignes));
	panel_set_value (long_ligne, sprintf(t,"%d\0",lect_lts->nbytes));
	panel_set_value (nbr_byte, sprintf(t,"%d\0",lect_lts->nvaleur));
	panel_set_value (saut_byte, sprintf(t,"%d\0",lect_lts->bytes_sautes));
	free(t);
    }
    window_fit (panel_lts);
    window_fit (frame_lts);

    window_set (panel_lts, PANEL_CARET_ITEM, name_lts, 0);
    lect_lts = (struct lecture_lts *)window_loop(frame_lts);
    return (lect_lts);
}

/*****************************************************************************/
/*                							     */
/* nom      : proc_lts							     */
/*									     */
/* fonction : initialise le panneau pour la lecture d'une image LTS          */
/*									     */
/* entrees  : Menu m                    : menu courant		             */
/*	      Menu_item mi		: item dans le menu		     */
/*									     */
/* globales : Frame frame_lts						     */
/*	      Panel panel_lts						     */
/*									     */
/* return   : neant                                                          */
/*								             */
/*								             */
/*****************************************************************************/

caddr_t proc_lts (m, mi)
    Menu m;
    Menu_item mi;
{
    struct lecture_lts *lect_lts, *copy_lts;


    if (flag_bother){
	hproc_acquis_lts();
	 return;
    }
    if (flag_help) hproc_acquis_lts();
    if (!flag_creer){
	sprintf (buf, mastertabs[142]);
	write_master (buf);
    }
    if (flag_exec == AUTO || flag_exec == PARAM_AUTO){
	lect_lts = (struct lecture_lts *)macro_cour->param;
	lect_lts->fp_lts = fopen (lect_lts->filename, "r");
    }
    else
	lect_lts = lts_panel(paneltabs[261]);
    if (flag_break) interruption();
    else {
	if (flag_creer){
	    struct commande *com;
	    fromto (TO, DEFAUT);
	    if (flag_break){
		interruption();
		return;
	    }
	    com = (struct commande *)new_commande (&macro_cour);
	    com->code = 4;
	    sprintf (com->nom, "I_OLIMLTS\0");
	    com->to[0] = index_image[1];
	    sprintf (buf, "I_OLIMLTS TO %d WITH %s %d %d %d %d %d\n\0",
		     index_image[1], lect_lts->filename,
		     lect_lts->header, lect_lts->nlignes, lect_lts->nbytes,
		     lect_lts->nvaleur, lect_lts->bytes_sautes);
	    write_macro (buf);
	    lect_lts->fp_lts = NULL;
	    copy_lts = (struct lecture_lts *)malloc(sizeof(*copy_lts));
	    *copy_lts = *lect_lts;
	    com->param = (char *)copy_lts;
	}
	else {
	    if (flag_exec==MANUEL || flag_exec==PARAM_AUTO || flag_exec==OFF)
		fromto (TO, DEFAUT);
	    else
		index_image[1] = macro_cour->to[0];
	    if (flag_break){
		interruption();
		return;
	    }
	    sprintf (buf, "%s %d %d %d %d %d --> %d\n", 
		 lect_lts->filename, lect_lts->header, lect_lts->nlignes,
		 lect_lts->nbytes, lect_lts->nvaleur, lect_lts->bytes_sautes,
		 index_image[1]);
	    write_master (buf); 
	    if (lect_lts->fp_lts != NULL){
		lire_filelts (index_image[1], lect_lts);
		fclose (lect_lts->fp_lts);
	    }
	    else write_erreur (20);
	}
    }
}


/*****************************************************************************/
/*                							     */
/* nom      : lire_filergb 						     */
/*									     */
/* fonction : lit dans le fichier fp_lts une image RGB (chaque point a ses   */
/*	      trois composantes consecutives) et stocke :		     */
/*	      le plan R dans dir_image[index_image[1]].image		     */
/*	      le plan G dans dir_image[index_image[3]].image		     */
/*	      le plan B dans dir_image[index_image[5]].image		     */
/*	      et met a jour le descripteur des plans-images		     */
/*									     */
/* entrees  : neant						             */
/*									     */
/* globales : dir_image					                     */
/*									     */
/* return   : neant                                                          */
/*								             */
/* routines : statis							     */
/*								             */
/*****************************************************************************/

int lire_filergb(imR, imG, imB, info)

int imR, imG, imB;
struct lecture_lts *info;

{
    register int taille, i, j;
    unsigned char *r, *g, *b, t, *d;
    
    fseek (info->fp_lts, (long)(info->header), 0);
    taille = info->nlignes * info->nvaleur;

    r = (unsigned char *) malloc (taille);
    g = (unsigned char *) malloc (taille);
    b = (unsigned char *) malloc (taille);
    if (dir_image[imR].image != NULL)
       free(dir_image[imR].image);
    if (dir_image[imG].image != NULL)
       free(dir_image[imG].image);
    if (dir_image[imB].image != NULL)
       free(dir_image[imB].image);
    dir_image[imR].image = r;
    dir_image[imG].image = g;
    dir_image[imB].image = b;

    for (j=0; j<info->nlignes; j++) {
	for (i=0; i<info->nvaleur; i++) {
            fread (r, sizeof(*r), 1, info->fp_lts);
	    fread (g, sizeof(*g), 1, info->fp_lts);
	    fread (b, sizeof(*b), 1, info->fp_lts);
            r++; g++; b++;
	}
        fseek (info->fp_lts, (long)(info->nbytes - info->nvaleur * 3), 1);
    }

    fclose (info->fp_lts);
    dir_desc[imR].type = 0;     /* type byte */
    dir_desc[imR].nligne = info->nlignes;
    dir_desc[imR].ncolonne = info->nvaleur;
    strcpy (dir_desc[imR].date, (char *) get_time());	    /* date et heure */
    strcpy (dir_desc[imR].filename, info->filename);	    /* nom fichier */
    dir_desc[imG] = dir_desc[imB] = dir_desc[imR];
    statis (dir_image[imR].image, dir_desc[imR].type, 
	    dir_desc[imR].nligne, dir_desc[imR].ncolonne,
            &(dir_desc[imR].mmin), &(dir_desc[imR].mmax),
	    &(dir_desc[imR].mu), &(dir_desc[imR].ecart));
    statis (dir_image[imG].image, dir_desc[imG].type, 
	    dir_desc[imG].nligne, dir_desc[imG].ncolonne,
            &(dir_desc[imG].mmin), &(dir_desc[imG].mmax),
	    &(dir_desc[imG].mu), &(dir_desc[imG].ecart));
    statis (dir_image[imB].image, dir_desc[imB].type, 
	    dir_desc[imB].nligne, dir_desc[imB].ncolonne,
            &(dir_desc[imB].mmin), &(dir_desc[imB].mmax),
	    &(dir_desc[imB].mu), &(dir_desc[imB].ecart));
    if (Histogramme[imR] != NULL)
	free(Histogramme[imR]);
    Histogramme[imR] = NULL;
    if (Histogramme[imG] != NULL)
	free(Histogramme[imG]);
    Histogramme[imG] = NULL;
    if (Histogramme[imB] != NULL)
	free(Histogramme[imB]);
    Histogramme[imB] = NULL;
    return;

}


/*****************************************************************************/
/*                							     */
/* nom      : proc_rgb							     */
/*									     */
/* fonction : initialise le panneau pour la lecture d'une image RGB          */
/*									     */
/* entrees  : Menu m                    : menu courant		             */
/*	      Menu_item mi		: item dans le menu		     */
/*									     */
/* globales : Frame frame_lts						     */
/*	      Panel panel_lts						     */
/*									     */
/* return   : neant                                                          */
/*								             */
/*****************************************************************************/

caddr_t proc_rgb (m, mi)
    Menu m;
    Menu_item mi;
{
    struct lecture_lts *lect_lts, *copy_lts;

    if (flag_bother){	
	 hproc_acquis_rgb();
	 return;
    }    
    if (flag_help)  hproc_acquis_rgb();
    if (!flag_creer){
	sprintf (buf,mastertabs[143]);
	write_master (buf);
    }
    if (flag_exec == AUTO || flag_exec == PARAM_AUTO){
	lect_lts = (struct lecture_lts *)macro_cour->param;
	lect_lts->fp_lts = fopen (lect_lts->filename, "r");
    }
    else
	lect_lts = lts_panel(paneltabs[262]);
    if (flag_break) interruption();
    else {
	if (flag_creer){
	    struct commande *com;
	    fromto (TO, DEFAUT);
	    if (flag_break) {
		interruption();
		return;
	    }
	    com = (struct commande *)new_commande (&macro_cour);
	    com->code = 4;
	    sprintf (com->nom, "I_OLIMLTS\0");
	    com->to[0] = index_image[1];
	    sprintf (buf, "I_OLIMLTS TO %d WITH %s %d %d %d %d %d\n\0",
		     index_image[1], lect_lts->filename,
		     lect_lts->header, lect_lts->nlignes, lect_lts->nbytes,
		     lect_lts->nvaleur, lect_lts->bytes_sautes);
	    write_macro (buf);
	    lect_lts->fp_lts = NULL;
	    copy_lts = (struct lecture_lts *)malloc(sizeof(*copy_lts));
	    *copy_lts = *lect_lts;
	    com->param = (char *)copy_lts;
	}
	else {
	    if (flag_exec==MANUEL || flag_exec==PARAM_AUTO || flag_exec==OFF)
		fromto (TO, RGB);
	    else
		index_image[1] = macro_cour->to[0];
	    if (flag_break){
		interruption();
		return;
	    }
	    sprintf (buf, "%s %d %d %d %d %d --> %d %d %d\n", 
	         lect_lts->filename, 
        	 lect_lts->header, lect_lts->nlignes, lect_lts->nbytes,
		 lect_lts->nvaleur, lect_lts->bytes_sautes, 
		 index_image[1], index_image[3], index_image[5]);
	    write_master (buf); 
	    if (lect_lts->fp_lts != NULL){
		lire_filergb(index_image[1], index_image[3], index_image[5], 
			    lect_lts);
		fclose (lect_lts->fp_lts);
	    }
	    else write_erreur (20);
	}
    }
}



/*****************************************************************************/
/*                							     */
/* nom      : lecture_mel						     */
/*									     */
/* fonction : lit une image en format melanie 8 ou 12 bits et la stocke dans */
/*            le tableau pointe par image_r.On calcule egalement les	     */
/*            statistiques de l'image et on les stocke dans desc	     */
/*									     */
/* entrees  : char *name                     : nom du directoire de l'image  */
/*					       (gel)			     */
/* globales : decription  desc               : statistiques de l'image       */
/*            Panel       filname            : panel de menu                 */
/*									     */
/* return   : TRUE si lecture de l'image s'est effectuee correctement        */
/*            FALSE si il y a une erreur				     */
/*								             */
/* routines : get_time()          retourne la date et l'heure		     */
/*            element(t)          retourne la taille en byte du type t       */
/*	      statis (param)      calcule la statistique d'une image         */
/*								             */
/*****************************************************************************/

int lecture_mel (noarr,fn)
    int	    noarr;
    struct  fname   *fn;
{ 
    unsigned char *b;
    short   *s;
    int	    place_element;
    register int i, j;

    /* on commence par remplir le descripteur */ 
    fread (&(dir_desc[noarr].nligne),sizeof(dir_desc[noarr].nligne),
	   1,fn->fpdesc);
                                                            /* nb de lignes  */
    fread (&(dir_desc[noarr].ncolonne),sizeof(dir_desc[noarr].ncolonne),
	   1,fn->fpdesc);
                                                            /*nb de colonnes */
    strcpy (dir_desc[noarr].date, (char *) get_time());        
                                                            /* date et heure */

     /* on va lire l'image */

    place_element = element (dir_desc[noarr].type);  /* taille d'un element */
    if (dir_image[noarr].image != NULL) free (dir_image[noarr].image);
    dir_image[noarr].image = (unsigned char *) malloc
	(dir_desc[noarr].ncolonne * dir_desc[noarr].nligne * place_element); 
                                          /* alloue de la place pour l'image */
    switch (place_element) {
	case 1 :    /* image en bytes */
	    b = (unsigned char *)dir_image[noarr].image;
            for (i = 0; i < dir_desc[noarr].nligne; i++) {
	        fread (b, sizeof(*b), dir_desc[noarr].ncolonne, fn->fpim);
                b += dir_desc[noarr].ncolonne;	
	    }
	    break; 
        case 2 :  /* image en shorts */
            s = (short *)dir_image[noarr].image;
            for (i = 0; i < dir_desc[noarr].nligne; i++) {
	       fread (s, sizeof(*s), dir_desc[noarr].ncolonne, fn->fpim);
               s += dir_desc[noarr].ncolonne;
            }	
            break;
    }
    statis (dir_image[noarr].image, dir_desc[noarr].type,
	    dir_desc[noarr].nligne, dir_desc[noarr].ncolonne,
            &(dir_desc[noarr].mmin), &(dir_desc[noarr].mmax), 
            &(dir_desc[noarr].mu), &(dir_desc[noarr].ecart));
    if (Histogramme[noarr] != NULL)
	free(Histogramme[noarr]);
    Histogramme[noarr] = NULL;
}


/*****************************************************************************/
/*									     */
/* nom      : proc_mel8							     */
/*									     */
/* fonction : initialise le panel pour la lecture d'une image melanie-8bits  */
/*                                                                           */
/* entrees  : Menu   m		        : menu courant                       */
/*            Menu_item mi	        : item dans le menu                  */
/*                                                                           */
/* globales : neant							     */
/*									     */
/* return   : neant                                     		     */
/*									     */
/* routines : neant							     */
/*									     */
/*****************************************************************************/
  
caddr_t  proc_mel8 (m, mi)
    Menu m;
    Menu_item mi;
{
    struct fname *fn, *copyfn;


    if (flag_bother){
	hproc_acquis_mel8();
	 return;
    }
    
    if (flag_help)  hproc_acquis_mel8();
    if (!flag_creer){
	sprintf (buf,mastertabs[144]); 
	write_master (buf);
    }
    if (flag_exec == AUTO || flag_exec == PARAM_AUTO){
	char *filen;
	filen = (char *)malloc(60);
	fn = (struct fname *)macro_cour->param;
	fn->fpim = fopen (sprintf(filen, "%s/image\0", fn->filename), "r");
	fn->fpdesc = fopen (sprintf(filen, "%s/f.info\0", fn->filename), "r");
    }
    else
	fn = fname_panel(paneltabs[263], paneltabs[264], 11);
    if (flag_break) interruption();
    else {
	if (flag_creer){
	    struct commande *com;
	    fromto (TO, DEFAUT);
	    if (flag_break){
		interruption();
		return;
	    }
	    com = (struct commande *)new_commande (&macro_cour);
	    com->code = 2;
	    sprintf (com->nom, "I_OLIMM8B\0");
	    com->to[0] = index_image[1];
	    sprintf (buf, "I_OLIMM8B TO %d WITH %s\n\0",
		     index_image[1], fn->filename);
	    write_macro (buf);
	    fn->fpim = fn->fpdesc = NULL;
	    copyfn = (struct fname *)malloc(sizeof(*copyfn));
	    *copyfn = *fn;
	    com->param = (char *)copyfn;
	}
	else {
	    if (flag_exec==MANUEL || flag_exec==PARAM_AUTO || flag_exec==OFF)
		fromto (TO, DEFAUT);
	    else
		index_image[1] = macro_cour->to[0];
	    if (flag_break){
		interruption();
		return;
	    }
	    sprintf (buf, "%s --> %d\n", fn->filename, index_image[1]);
	    write_master (buf); 
	    dir_desc[index_image[1]].type = 0;
	    if (fn->fpdesc != NULL && fn->fpim != NULL){
		lecture_mel(index_image[1],fn);
		fclose (fn->fpim);
		fclose (fn->fpdesc);
	    }
	    else write_erreur (20);
	}
    }
}  

/*****************************************************************************/
/*									     */
/* nom      : proc_mel12						     */
/*									     */
/* fonction : initialise le panel pour la lecture d'une image melanie-12bits */
/*                                                                           */
/* entrees  : Menu   m		        : menu courant                       */
/*            Menu_item mi	        : item dans le menu                  */
/*                                                                           */
/* globales : neant							     */
/*									     */
/* return   : neant                                     		     */
/*									     */
/* routines : neant							     */
/*									     */
/*****************************************************************************/

caddr_t  proc_mel12 (m,mi)
    Menu m;
    Menu_item mi;
{
    struct fname *fn, *copyfn;


    if (flag_bother){
	 hproc_acquis_mel12();
	 return;
    }    
    if (flag_help)  hproc_acquis_mel12();
    if (!flag_creer){
	sprintf (buf, mastertabs[145]);
	write_master (buf);
    }
    if (flag_exec == AUTO || flag_exec == PARAM_AUTO){
	char *filen;
	filen = (char *)malloc(60);
	fn = (struct fname *)macro_cour->param;
	fn->fpim = fopen (sprintf(filen, "%s/image\0", fn->filename), "r");
	fn->fpdesc = fopen (sprintf(filen, "%s/f.info\0", fn->filename), "r");
    }
    else
	fn = fname_panel(paneltabs[265], paneltabs[264], 12);
    if (flag_break) interruption();
    else {
	if (flag_creer){
	    struct commande *com;
	    fromto (TO, DEFAUT);
	    if (flag_break){
		interruption();
		return;
	    }
	    com = (struct commande *)new_commande (&macro_cour);
	    com->code = 3;
	    sprintf (com->nom, "I_OLIMM12B\0");
	    com->to[0] = index_image[1];
	    sprintf (buf, "I_OLIMM12B TO %d WITH %s\n\0",
		     index_image[1], fn->filename);
	    write_macro (buf);
	    fn->fpim = fn->fpdesc = NULL;
	    copyfn = (struct fname *)malloc(sizeof(*copyfn));
	    *copyfn = *fn;
	    com->param = (char *)copyfn;
	}
	else {
	    if (flag_exec==MANUEL || flag_exec==PARAM_AUTO || flag_exec==OFF)
		fromto (TO, DEFAUT);
	    else
		index_image[1] = macro_cour->to[0];
	    if (flag_break){
		interruption();
		return;
	    }
	    sprintf (buf, "%s --> %d\n", fn->filename, index_image[1]);
	    write_master (buf); 
	    dir_desc[index_image[1]].type = 1;
	    if (fn->fpdesc != NULL && fn->fpim != NULL){
		lecture_mel(index_image[1],fn);
		fclose (fn->fpim);
		fclose (fn->fpdesc);
	    }
	    else write_erreur (20);
	}
    }
}  


