/*
	Author		John Plevyak
	Notes		:

*/

#include <stdio.h>
#include <unistd.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <sys/time.h>

#include <string.h>

#include <dtmint.h>
#include <debug.h>
#include <math.h>

#include "test.h"


/*
	MACRO DEFINITIONS
*/

#define	USAGE	"Usage: %s inport1 outport1 [inport2 outport2 ...] [-scASH]\n\
		-s	hub configuration [default]\n\
		-c	fully connected graph\n\
		-A	asyncronous [default]\n\
		-a	avail write on hub\n\
		-o	avail write one ahead on hub\n\
		-S	syncronous\n\
		-C	client [default]\n\
		-H	hub\n\
		-q	quiet\n\
		-p	performance test\n\
		-l#	number of loops to perform\n\
		-d	debug\n\
		-h# header size in bytes\n\
		-x# data size in bytes\n\
		-D#	delays n millisecs per loop\n"

#ifdef FALSE
#undef FALSE
#endif
#define	FALSE			0
#ifdef TRUE
#undef TRUE
#endif
#define	TRUE			1
#ifndef NULL
#define	NULL			0
#endif
#define	SIZE(x)	(sizeof(x)/sizeof((x)[0]))
#define	forever while(1)


/*
	TYPE DEFINITIONS
*/

static char hdr[ 100 ];
static int	hdrsize = 4;
static char data[1000 ];
static int	datasize = 8;
static int	datatype = DTM_CHAR;

/*
	GLOBAL FUNCTIONS
*/


usage( progName) 
char	* progName;
{
	fprintf( stdout, USAGE, progName );
	exit( 1 );
}


char *sherr( errcode )
	int	errcode ;
{
	if( errcode == DTMSOCK )
	{
		static	char	tbuf[ 132 ] ;
		sprintf( tbuf, "%s, errno = %d", DTMerrmsg(TRUE), errno );
		return tbuf ;
	}
	return DTMerrmsg(TRUE);
}	

delay( mil ) 
	int	mil;
{
	fd_set	fdset;	
	int 	fd = 0;
	static struct timeval	tv = {0,0};

	FD_ZERO(&fdset);
	FD_SET(fd, &fdset);
	tv.tv_sec =  mil / 1000;
	tv.tv_usec = (mil % 1000)*1000;
	select(0,NULL,NULL,NULL, &tv );
	/* select(31,fdset,0,0,tv ); */
}

int	get_number( argv )
	char ** argv;
{ 
	char * pnum = *argv;
	int		ret = 0;
	pnum++; 
	while (isdigit(*pnum)) 
		ret = ret * 10 + (*pnum++ - '0');
	pnum--; *argv = pnum;
	return ret;
}

main( argc, argv )
	int		argc ;
	char	*argv[] ;
{
	char	*portName[ MAX_PORT_NAMES ] ;
	int		inPorts[ MAX_PORT_NAMES / 2 ];
	int		outPorts[ MAX_PORT_NAMES / 2 ];
	int		portNameCount = 0;
	int		fStar = TRUE;
	int		fAvailWriteHub = FALSE;
	int		fAvailOneHub = FALSE;
	int		qservice = DTM_ASYNC;
	int		fHub = FALSE;
	int		ok = TRUE;
	int		quiet = FALSE;
	int		performance = FALSE;
	int		loops = 0; /* forever */
	int		mdelay = 0;
	char	*progname = argv[0];

	if( argc <= 2 ) usage( progname ); 

	/*
		No port names begining with a dash
	*/
	if ((*++argv)[0] == '-' ) usage( --argv );
	--argv;
	while ( *++argv && ( (*argv)[0] != '-' )) 
		portName[ portNameCount++] =  *argv;
	portName[ portNameCount ] = NULL;
	--argv;

	while ( *++argv && (*argv)[0] == '-' ) {
		while ( *(++(*argv)) ) {
			switch ( **argv )  {
				case 's' : fStar = TRUE;					break;
				case 'c' : fStar = FALSE;					break;
				case 'd' : uDTMdbg = DTM_DBG_MSG;			break;
				case 'S' : qservice = DTM_SYNC;				break;
				case 'A' : qservice = DTM_ASYNC;			break;
				case 'H' : fHub = TRUE;						break;
				case 'a' : fAvailWriteHub = TRUE;			break;
				case 'o' : fAvailOneHub = TRUE;				break;
				case 'C' : fHub = FALSE;					break;
				case 'q' : quiet = TRUE;					break;
				case 'p' : performance = TRUE;				break;
				case 'h' : hdrsize = get_number( argv ); 	break;
				case 'x' : datasize = get_number( argv ); 	break;
				case 'l' : loops = get_number( argv ); 		break;
				case 'D' : mdelay = get_number( argv );		break;
				default:
					usage( progname );
			}
		}
	}
	--argv;
	if ( portNameCount < 2 ) usage( progname );
	if (!mdelay ) {
		if ( !fHub ) mdelay = 50;
	}	
	srandom( getpid() );
	{
		int	i;
		if ( fStar ) {
			if (!quiet) printf("%s: Openning Input port(s)\n", progname);
			if (!quiet) printf("	input port: [%s]\n", portName[0]);
			if ( (inPorts[0] = DTMmakeInPort( portName[0], qservice)) < 0 ) {
				fprintf( stderr, "%s: error opening %s: %s\n", progname,
					portName[0], sherr( DTMerrno ) );
				exit( 1 );
			}
			if (!quiet) printf("%s: Openning Output port(s)\n", progname);
			for ( i = 1; i < portNameCount ; i++ ) {
				if (!quiet) printf("	output port: [%s]\n", portName[i - 1]);
				if ( (outPorts[i - 1] = DTMmakeOutPort( 
						portName[i], qservice)) < 0 ) {
					fprintf( stderr, "%s: error opening %s: %s\n", progname,
						portName[i], sherr( DTMerrno ) );
					exit( 1 );
				}
			}
		} else {
			for ( i = 0; i < portNameCount ; i += 2 ) {
				if (!quiet) printf("%s: Openning Input port(s)\n", progname);
				if ( (inPorts[i/2] = DTMmakeInPort( portName[i], qservice))<0){
					fprintf( stderr, "%s: error opening %s: %s\n", progname,
						portName[i], sherr( DTMerrno ) );
					exit( 1 );
				}
				if (!quiet) printf("%s: Openning Output port(s)\n", progname);
				if ( (outPorts[i/2] = DTMmakeOutPort( 
						portName[i + 1], qservice)) < 0 ) {
					fprintf( stderr, "%s: error opening %s: %s\n", progname,
						portName[i + 1], sherr( DTMerrno ) );
					exit( 1 );
				}
			}
		}
	}

	if ( fHub ) {
		int	i;
		int	loop_num = 1;
		Dtm_set	dtmset[ MAX_PORT_NAMES / 2 ];
		for ( i = 0; i < 1; i++ ) 
				dtmset[i].port = inPorts[i];
		forever { 	
			int	result;
			if (!quiet) printf("%s: Hub top of loop #%d\n", 
				progname, loop_num);
		/*
			if ( (result = DTMavailRead( inPorts[0])) < 0 ) {
		*/
			if ( (result = DTMselectRead( dtmset, 1, 0, 0, 100000)) < 0 ) {
				fprintf( stderr, "%s: error calling selectRead %s: %s\n", 
					progname,
					portName[0], sherr( DTMerrno ) );
				exit( 1 );
			}		
			if (!quiet) printf("%s: Hub past select\n", progname);
			if ( result > 0 ) {
				loop_num++;
			/*
				for ( i = 0; i < 1; i++ ) {
					if ( dtmset[i].status == DTM_PORT_READY ) {
			*/
						if (!quiet) printf("%s: Hub reading\n", progname);
						if ( DTMreadMsg( inPorts[0], hdr, hdrsize,
								data, datasize, datatype ) < 0)	{
							fprintf( stderr, 
								"%s: error calling readMsg %s: %s\n", 
								progname,
								portName[i * 2], sherr( DTMerrno ) );
							exit( 1 );
						}
						if (!quiet) printf( "Hub: read from %s\n", portName[0]);
						if (!quiet) printf("%s: Hub writing\n", progname);
						if ( fAvailWriteHub )
							for ( i = 0; i < portNameCount - 1; i++ ) {
								int result =  DTMavailWrite( outPorts[i] );
							}
						for ( i = 0; i < portNameCount - 1; i++ ) {
							if ( fAvailOneHub && i < portNameCount - 3) {
								int result =  DTMavailWrite( outPorts[i + 1] );
								result =  DTMavailWrite( outPorts[i + 2] );
							}
							if ( DTMwriteMsg( outPorts[i],  hdr, hdrsize,
									data, datasize, datatype ) < 0)	{
								fprintf( stderr, 
									"%s: error calling writeMsg %s: %s\n", 
									progname,
									portName[i + 1], sherr( DTMerrno ) );
								exit( 1 );
							}
							if ( !quiet ) printf( "Hub: sent\n", i);
						}
			/*
					}
				}
			*/
			}
			if ( loop_num  - 1 == loops ) break;
			if (!quiet) printf("%s: Hub delaying\n", progname);
			if ( mdelay )
				delay( random() % mdelay );
		}
	} else {
		int	loop_num = 1;
		int	delayed = 0;
		forever {
			int result =  DTMavailRead( inPorts[0] );
			if (!quiet) printf("%s: Client top of loop #%d\n", 
				progname, loop_num);
			if ( result < 0 ) {
				fprintf( stderr, 
					"%s: error calling availRead %s: %s\n", 
					progname,
					portName[0], sherr( DTMerrno ) );
				exit( 1 );
			}
			if ( result > 0 ) {
				if (!quiet) printf("%s: Client begining to read\n", progname);
				if ( DTMreadMsg( inPorts[0], hdr, hdrsize,
						data, datasize, datatype ) < 0)	{
					fprintf( stderr, 
						"%s: error calling readMsg %s: %s\n", 
						progname,
						portName[0], sherr( DTMerrno ) );
					exit( 1 );
				}
				if (((int *)data)[0] == getpid()) {
					printf("on %d got %d\n", loop_num, ((int *)data)[1]);
				}
				if ( !quiet ) printf( "Client: %d got\n", getpid());
				continue;
			}
			if ( loop_num == loops ) continue;
			/* delay( 1 ); */
			delayed++;
			if (delayed < mdelay) continue;
			delayed = 0;
			result =  DTMavailWrite( outPorts[0] );
			if ( result < 0 ) {
				fprintf( stderr, 
					"%s: error calling availWrite %s: %s\n", 
					progname,
					portName[1], sherr( DTMerrno ) );
				exit( 1 );
			}
			if ( result > 0 ) {
				if (!quiet) printf("%s: Client begining to write to %s\n", 
					progname, portName[1]);
				((int *)data)[0] = getpid();
				((int *)data)[1] = loop_num;
				if ( DTMwriteMsg( outPorts[0], hdr, hdrsize,
						data, datasize, datatype ) < 0)	{
					fprintf( stderr, 
						"%s: error calling writeMsg %s: %s\n", 
						progname,
						portName[1], sherr( DTMerrno ) );
					exit( 1 );
				}
				if (!quiet) printf("%s: Client delaying\n", progname);
				loop_num++;
				if ( !quiet) printf( "Client: %d wrote\n", getpid());
			}
		}
	}

	exit( !ok ); 
}
