/*
	Author		: Sreedhar Sivakumaran
	Notes		:
	
		Test function to open an inport and outport, 
		get their names, and then close them.
	
		Questions - 

		1. Should DTMerrno be in dtm.h ?
			yes, done -- john
*/

#include <stdio.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <dtmint.h>
#include <dtm.h>
#include "test.h"


/*
	Function to test makeport/getportaddr/destroyport.

	Returns		:	0 on failure.
				1 on success.

	Notes		:	It creates specified number of DTM in and out ports,
				gets their address and then closes them.				
*/

static int	initPrivate( inpname, outpname, count )
	char	*inpname ;
	char	*outpname ;
	int	count ;
{
	int		inport[ TEST_DTM_PORTS ] ;
	int		outport[ TEST_DTM_PORTS ] ;
	char	buf[ MAXHOSTNAMELEN + 1 + KEYLEN ] ;
	reg int	temp ;
	int		err, temp1 ;

	err = 1 ;	/* success by default	*/

	temp = 0 ;
	temp1 = 0 ;
	while( temp < count )
	{
		/*	Open the in and out ports.		*/

		if( (inport[temp] = DTMmakeInPort( inpname, DTM_SYNC )) == DTMERROR ) {
			fprintf( stderr, "%%Test: Inport open error %s\n", 
					sherr( DTMerrno ) );
			err =  0 ;
			break ;
		}
		if((outport[temp] = DTMmakeOutPort( outpname,  DTM_SYNC)) == DTMERROR ) {
			fprintf( stderr, "%%Test: Outport open error, %s\n", 
					sherr(DTMerrno));
			err =  0 ;
			break ;
		}

		/*	Get the inport name. Get of outportname is not supported	*/

		if( DTMgetPortAddr( inport[ temp ], buf, sizeof buf ) == DTMERROR )
		{
			fprintf( stderr, "%%Test: Inport %d address get error, %s\n", inport[ temp ], sherr( DTMerrno ) );
			err =  0 ;
			break ;
		}
		else
		{
			if( count == 1 )
				fprintf( stdout, "%%Test: Inport is %s\n", buf );
		}
		temp1++ ;
		temp++ ;
	}

	temp = 0 ;
	while( temp < temp1 )
	{
		/*	Close the in and out ports.		*/

		if( DTMdestroyPort( inport[ temp ] ) == DTMERROR )
		{
			fprintf( stderr, "%%Test: Inport %d destroy error, %s\n", inport[ temp ], sherr( DTMerrno ) );
			err =  0 ; break ;
		}
		if( DTMdestroyPort( outport[ temp ] ) == DTMERROR )
		{
			fprintf( stderr, "%%Test: Outport %d destroy error, %s\n", outport[ temp ], sherr( DTMerrno ) );
			err =  0 ; break ;
		}
		temp++ ;
	}
	
	return err ;
}

int DTMtestCreateDestroy()
{
register char	*name, *iname, *oname  ;
		
	if( initPrivate( name = "i", "o:99", 1 ) )
	{
		fprintf( stderr, "%%Test: ERROR - initPrivate accepted incorrect inportname %s\n", name );
		return 0 ;
	}
	else
	{
		fprintf( stdout, "%%Test: Incorrect inportname %s rejected \n", name );
	}
	if( initPrivate( "i:9999", name = "o", 1 ) )
	{
		fprintf( stderr, "%%Test: ERROR - initPrivate accepted incorrect outportname %s\n", name ) ; 
		return 0 ;
	}
	else
	{
		fprintf( stdout, "%%Test: Incorrect outportname %s rejected \n", name );
	}
	if( initPrivate( name = "x:99", "x:99", 1 ) )
	{
		fprintf( stderr, "%%Test: ERROR - initPrivate accepting invalid in/out port names %s (portno should be > %d)\n", name, MINPORTNO );
		return 0 ;
	}
	else
	{
		fprintf( stdout, "%%Test: Port no <= %d rejected \n", MINPORTNO );
	}
	if( !initPrivate( iname = "bardeen:1025", oname = "bardeen:7700", 1 ) )
	{
		fprintf( stderr, "%%Test: ERROR - initPrivate not accepting valid in name %s, out name %s\n", iname, oname );
		return 0 ;
	}
	else
	{
		fprintf( stdout, "%%Test: inname %s, outname %s accepted\n", 
				iname, oname );
	}
	if( !initPrivate( iname = "i:0", oname = "o:0", 1 ) )
	{
		fprintf( stderr, 
		"%%Test: ERROR - initPrivate not accepting in name %s out name %s\n", 
				iname, oname );
	}
	else
	{
		fprintf( stdout, "%%Test: inname %s, outname %s accepted\n", 
				iname, oname );
	}
	if( !initPrivate( iname = "i:0", oname = "o:0", TEST_DTM_PORTS ) )
	{ 
		fprintf( stdout, 
		"%%Test: WARNING - initPrivate not opening up to maximum of %d ports\n"
				, TEST_DTM_PORTS );
	}
	else
	{
		fprintf( stdout, "%%Test: Maximum of %d ports accepted\n", 
				TEST_DTM_PORTS );
	}
	if( initPrivate( iname = "i:0", oname = "o:0", TEST_DTM_PORTS + 1 ) )
	{ 
		fprintf( stderr, 
			"%%Test: ERROR - initPrivate opening > maximum of %d ports\n", 
				TEST_DTM_PORTS );
		return 0 ;
	}
	else
	{
		fprintf( stdout, "%%Test: > Maximum of %d ports not accepted\n", 
				TEST_DTM_PORTS );
	}

	return	1 ;
}
