/*--------------------------------------------------------------------------*
 *
 * Usage :
 *
 *   tiff2hdf tiff_file [index] hdf_file [-append]
 *
 * Compile :
 *
 *   cc tiff2hdf.c tiffutils.o utils.o -o tiff2hdf -ltiff -ldf
 *
 * 				NO WARRANTY
 *  
 *  This software is distributed free of charge and is in the public domain.
 *  Anyone may use, duplicate or modify this program.  Thinking Machines
 *  Corporation does not restrict in any way the use of this software by
 *  anyone.
 *  
 *  Thinking Machines Corporation provides absolutely no warranty of any kind.
 *  The entire risk as to the quality and performance of this program is with
 *  you.  In no event will Thinking Machines Corporation be liable to you for
 *  damages, including any lost profits, lost monies, or other special,
 *  incidental or consequential damages arising out of the use of this program.
 * 
 * Jim Salem 9/26/89
 * Please keep this notice with the file.
 *
 * RCS: $Id: tiff2hdf.c,v 2.0 90/08/01 11:04:13 salem Exp $
 *  $Log:	tiff2hdf.c,v $
 * Revision 2.0  90/08/01  11:04:13  salem
 * Bump to next release, no changes
 * 
 * Revision 1.1  90/07/30  18:37:10  salem
 * Initial revision
 * 
 *
 *--------------------------------------------------------------------------*/

#include "utils.h"
#include <tiff/tiffio.h>

/*--------------------------------------------------------------------------*
 * Global Vars.
 *--------------------------------------------------------------------------*/

static
  char *progname;		/* argv[0] */

/*--------------------------------------------------------------------------*
 * Utilities
 *--------------------------------------------------------------------------*/

extern void signal_hdf_error();
extern long strtol();

static
  int parse_uint (string)
char *string;
/* Returns -1 if error otherwise the integer */
{
  long ret;
  char *ptr;

  ret = strtol(string, &ptr, 10);
  if (ret < 0 || ptr != string + strlen(string))
    return -1;
  else
    return ret;
}

static
  void bad_usage ()
{
  fprintf(stderr,"Usage: %s tiff_file [index] hdf_file [-append]\n\
  index identifies the particular image within the TIFF file (default 0)\n\
  If -append is present, the HDF file is appended.\n", progname);
  exit (1);
}

/*--------------------------------------------------------------------------*
 * Main
 *--------------------------------------------------------------------------*/

void
  main (argc, argv)
int argc;
char **argv;
{
  int index = 0;
  char *tiff_filename;
  char *hdf_filename;
  Boolean append_p, index_required;

  progname = argv[0];

  /* argument parsing */
  tiff_filename = argv[1];
  switch (argc)
    {case 5:
       if (strcmp(argv[4],"-append")) bad_usage();
       append_p = True;
       hdf_filename = argv[3];
       index_required = True;
       break;
     case 4:
       if (strcmp(argv[3],"-append")) {
	 append_p = False;
	 index_required = True;
	 hdf_filename = argv[3];
       }
       else {
	 append_p = True;
	 index_required = False;
	 hdf_filename = argv[2];
       }
       break;
     case 3:
       append_p = False;
       index_required = False;
       hdf_filename = argv[2];
       break;
     default:
       bad_usage();
       break;
     }

  if (index_required) {
    index = parse_uint (argv[2]);
    if (index < 0) bad_usage();
  }

  if (! tiff_file_to_hdf (tiff_filename, index, hdf_filename, append_p, NULL))
    signal_hdf_error(progname);

  exit(0);
}

    
