      
      program sdsampl1
C
C
C  Program to write out a small SDS, then read it back in and compare
C  the results.
C
C  Input file:  none
C  Output file: test.hdf
C

      integer dsgdims, dsgdata, dssdims
      integer rows, cols
      integer ret, i, j
      integer rank, inRank
      integer shape(2), inShape(2)
      real    pressure(3,4), inPressure(3,4)
      
      rows = 3
      cols = 4
      rank = 2
      shape(1) = rows
      shape(2) = cols
      
      do 110 i = 1, rows
        do 100 j = 1, cols
          pressure(i,j) = i+10*j
  100   continue
  110 continue

C Write data to file
      ret = dssdims(rank, shape)
      ret = dspdata('test.hdf',2, shape, pressure)

C Read data back
      ret = dsgdims('test.hdf',inRank, inShape, 2)
      ret = dsgdata('test.hdf',inRank, inShape, inPressure)

C Compare information read in with original information
      print *,  'Output rank is:', rank
      print *,  'Input rank is: ', inRank
      print *,  'Output shape is :', shape(1), shape(2)
      print *,  'Input shape is  :', InShape(1), inShape(2)

      do 210 i = 1, rows
        do 200 j = 1, cols
          if (pressure(i,j) .ne. inPressure(i,j)) then
             print *, 'Array position ',i,j,'is different'
          endif
  200   continue
  210 continue

      do 300 i=1,rows
        print *, 'out:',(pressure(i,j),j=1,cols),
     1           '  in:',(inPressure(i,j),j=1,cols)
  300 continue

      end
