#include "Contour.h"
/*
	~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	ContourDraw		draw the contour lines
	This routine contains all the mac independent code!
	
				contour =	pointer to contour record
				inData 	 =	pointer to input data
				outData  =	pointer to output data
				nx    	 = number of x-points in the array
				ny    	 = number of y-points in the array
	~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
*/
ContourDraw(contour, inData, outData, nx, ny)
	ContourRec                              *contour;
	unsigned char                   *inData, *outData;
	unsigned long                                   nx, ny;
{
	unsigned char                   *c,contours[256];
	int                             nlevels,i;
	register unsigned char  color,background;
	void                            ContourLine();


	background      = (unsigned char)(contour->back);
	nlevels         = contour->levels;

	for (i = 0; i < nlevels; i++)
			*(contours + i) = (unsigned char) contour->list[i];

	c = outData;
	for (i = 0; i < nx*ny; i++)
			*c++ = background;

	c = contours;
	if (contour->colorPlot)
		while (nlevels > 0)
			{
			ContourLine (inData, outData,*c,*c,nx,ny);
			c++;
			nlevels -= 1;
			}
	else
		{
		color = (unsigned char)(contour->color);
		while (nlevels > 0)
			{
			ContourLine (inData, outData,*c++,color,nx,ny);
			nlevels -= 1;
			}
		}
	
}
/*
	~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	ContourLine		draw a contour line
	
			indata =	pointer to input data
			godata = 	pointer to output data
			value =		the value of the contour level (0-255)
			color =		the color of the contour level (0-255)
			x =			number of x-points in the array
			y =			number of y-points in the array
	~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
*/
void	ContourLine(indata,godata,value,color,x,y)
		unsigned char			*indata,*godata;
		register unsigned char	value,color;
		register long			x;
		long					y;
{
		register unsigned char	*p,*u;
		unsigned char			*q;
		int						rows_done = 0;
		
		p = indata;
		q = p + (long)(x * y - 1);
		u = indata + (long)(x - 1);
		
		while (!rows_done)
			  {while (p < u)
			   		 {if	  (*p < value)
							  {while (*p < value && p < u) p++;
							   if (*p >= value)
								  *(godata + (long)(p - indata)) = color;
							  }
					  else if (*p == value)
							  {while (*p == value && p < u) p++;
							   if (*p < value || *p > value)
								  *(godata + (long)(p - indata)) = color;
							  }
					  else
							  {while (*p > value && p < u) p++;
							   if (*p <= value)
								  *(godata + (long)(p - indata)) = color;
							  }
					 }
			   if (u == q)	rows_done = 1;
			   else
			   		{u += x;
			   		 p++;
					}
			  }
		
		p = indata;
		q = p + (long)(x * y - 1);
		u = q - (long)(x - 1);
		
		while (u <= q)
			  {while (p < u)
			   		 {if	  (*p < value)
							  {while (*p < value && p < u) p += x;
							   if (*p >= value)
								  *(godata + (long)(p - indata)) = color;
							  }
					  else if (*p == value)
							  {while (*p == value && p < u) p += x;
							   if (*p < value || *p > value)
								  *(godata + (long)(p - indata)) = color;
							  }
					  else
							  {while (*p > value && p < u) p += x;
							   if (*p <= value)
								  *(godata + (long)(p - indata)) = color;
							  }
					 }
			   if (u == q)	return;
			   u++;
			   p = indata + (long)(x - 1) - (long)(q - u);
			  }
}