%***************************************************************************
%  FILE = utility2.red 	   			Tue Dec  6 19:37:18 EST 1988
% 
%  Procedures in this file:
%  
%  DIR NODIR HELP MYSPRINT REM REM1 KILL SAVEI* SAVEC* 
%  SAVEIC SAVEI2 SAVEC2 UNIQKERN FINDKERN FINDKERN1 FINDKERN2 
%  IAS* COPY** COPY* MAPFI* MKCOORDS* MKCOORDS DELTA* 
%  MULTIPLIER
% 
%  REDTEN source code
%  Copyright (c) 1986, 1987 University of Toronto.
%  All Rights Reserved.
%
%  Written by John Harper and Charles Dyer
%
%  Permission to use this software without fee is granted subject to 
%  the following restrictions:
% 
%  1. This software may not be used or distributed for direct commercial
%     gain.
% 
%  2. The author is not responsible for the consequences of use of this
%     software, no matter how awful, even if they arise from flaws in it.
% 
%  3. The origin of this software must not be misrepresented, either by
%     explicit claim or by omission.
% 
%  4. This code may be altered to suit your need, but such alterations
%     must be plainly marked and the code must not be misrepresented
%     as the original software.
% 
%  5. This notice may not be removed or altered.
% 
%**********************************************************************
REMPROP ('INDEX, 'STAT);
GLOBAL '(INAMES);	% where all the names are kept.

% dir is the routine with which the user can see the names and some
% attributes of indexed objects in the system. objects flagged 'nodir are
% not displayed, but are counted into the final summary.

RLISTAT '(DIR);

SYMBOLIC PROCEDURE DIR (LEX);
BEGIN SCALAR LEX1, LEX2, I, N, POSN, SCNAMES, ASKED, LINELEN;
  IF NOT MYCAR (LEX) AND NOT INAMES THEN <<    % nothing yet made by the user.
    PRIN2 ("no objects");
    TERPRI ();
    RETURN ('T)
  >>;
  LINELEN := LINELENGTH (100);   % lengthen line to avoid premature wraps
  N := I := 0;		% number of elements and number of objects.
  IF NOT MYCAR (LEX) THEN LEX := INAMES
  ELSE ASKED:= 'T;
  SPACES (2);		% print header line
  PRIN2 ("name");
  SPACES (10);
  PRIN2 ("type");
  SPACES (9);
  PRIN2 ("elements");
  SPACES (1);
  PRIN2 ("prot");
  SPACES (2);
  PRIN2 ("coordinates");
  SPACES (5);
  PRIN2 ("concov");
  TERPRI ();

  WHILE LEX DO <<
    LEX1 := MYCAR (LEX);		% current name
    LEX := MYCDR (LEX);
    IF INDEXED (LEX1) EQ 'SCALAR THEN SCNAMES := LEX1 . SCNAMES % scalar object
    ELSE IF NOT ASKED AND FLAGP (LEX1, 'NODIR) THEN << % dont print, but add to summary
      I := I + 1;
      N := N + LENGTH (GET (LEX1, 'TVALUE))
    >> ELSE <<
      I := I + 1;
      N := N + LENGTH (GET (LEX1, 'TVALUE));
      SPACES (2);
      POSN := 2 + FLATSIZE2 (PRIN2 (LEX1));	% posn aids in tabbing over
      SPACES (16 - POSN);
      LEX2 := GET (LEX1, 'TYPE);
      POSN := 16 + FLATSIZE2 (PRIN2 (LEX2 OR ""));
      SPACES (31 - POSN);
      POSN := 31 + FLATSIZE2 (PRIN2 (LENGTH (GET (LEX1, 'TVALUE))));
      IF GET (LEX1, 'IMPLICIT) THEN
        POSN := POSN  + FLATSIZE2 (PRIN2 ("+"));
      SPACES (39 - POSN);
      IF ISPROTECT (LEX1, 6) THEN PRIN2 ("KW")
      ELSE IF ISPROTECT (LEX1, 3) THEN PRIN2 ("K ")
      ELSE IF ISPROTECT (LEX1, 2) THEN PRIN2 ("W ")
      ELSE PRIN2 ("  ");
      SPACES (3);
      POSN := 42 + FLATSIZE2 (PRIN2 (GET (LEX1, 'COORDS)));
      SPACES (58 - POSN);
      POSN := 58 + FLATSIZE2 (PRIN2 (GET (LEX1, 'CONCOV)));
      TERPRI ();
      POSN := 0
    >>
  >>;
  TERPRI ();
  SPACES (1);		% summary
  PRIN2 (I);
  PRIN2 (" object(s),     Total elements: ");
  PRIN2 (N);
  TERPRI ();
  TERPRI ();
  IF SCNAMES THEN <<	% names of scalar objects.
    PRIN2 (" scalar objects: ");
    MAPCAR (SCNAMES, 'MYSPRINT);
    TERPRI!* ('NIL);
    TERPRI ()
  >>;
  LINELENGTH (LINELEN);
  RETURN ('T);
END;

RLISTAT '(NODIR);	% parser collects up a list.

% nodir declares a list of names to be not eligible for display by dir.

SYMBOLIC PROCEDURE NODIR (U);
<<
  FLAG (LIST (U), 'NODIR);
  U
>>;

GLOBAL '(HELPLIST!* PAGERPROG!*);	% assoc list of function names and keys
PUT ('HELPLIST!*, 'HELPFILE, "help.txt");  % full path to help file
FLAG ('(HELP), 'OPFN);
PUT ('HELP, 'FORMFN, 'HELP);

% help* is used to obtain on-line help about functions in the
% tensor system. given no arguments help* prints a list of all
% functions for which help is available. Otherwise, more is
% spawned to look for the function in the help file.

SYMBOLIC PROCEDURE HELP (U);
BEGIN SCALAR EX, I, LEX;
  EX := MYCAR (U);
  IF NOT ATOM (EX) THEN EX := MYCAR(EX);	% for RLIS fns.
  IF NOT EX THEN <<	% no arg, dump all names
    PRIN2 ("Help is available on:");
    TERPRI ();
    MAPCAR (MAPCAR (HELPLIST!*, 'MYCAR), 'MYSPRINT);
    TERPRI!* ('NIL);
    RETURN ('T)
  >>
  ELSE IF NOT (LEX := MYCADR (ASSOC (EX, HELPLIST!*))) THEN <<
    PRIN2 ("no help available.");
    TERPRI ();
    RETURN ('NIL)
  >>
  ELSE <<
    LEX := CONCAT (CONCAT (CONCAT (PAGERPROG!*, " +/\^"), LEX),
           CONCAT (" ",  GET ('HELPLIST!*, 'HELPFILE)));
    SYSTEM (LEX)
  >>;
  'T;
END;

% mysprint merely prints its input followd by a space. when mapped over
% a list, line breaks come in at appropriate places because we are using
% the reduce print routines.

SYMBOLIC PROCEDURE MYSPRINT (U);
BEGIN;
  PRIN2!* (U);
  PRIN2!* (" ");
END;

GLOBAL '(KILLED!*);	% list of names killed by recursive calls to kill.
KILLED!* := 'NIL;
PUT ('REM, 'FORMFN, 'REM);   % easy way to get an unevaled list.

% rem is the user interface to the kill routine. given a list of names
% it tries to wipe these out.  if 'all is given, and the second argument
% is 'nil, rem interactively removes all objects. if the second argument
% is non-'nil, rem removes all  objects non-interactively. it prints
% a list of all objects successfully removed.

SYMBOLIC PROCEDURE REM (LIS, VARS, MODE);
BEGIN;
  KILLED!* := 'NIL;
  IF MYCAR (LIS) EQ 'ALL AND NOT MYCADR (LIS) THEN   % interactive mode
    RETURN (REM1 (INAMES))
  ELSE IF MYCAR (LIS) EQ 'ALL THEN LIS := INAMES;	 % wipe everthing
  FOR EACH X IN LIS DO KILL (X);
  TERPRI ();
  WRITE (" ", KILLED!*);
  TERPRI ();
END;

% rem1 is the interactive routine called by rem. it guides the user through
% the process of deleting objects.
GLOBAL '(PROMPTEXP);

SYMBOLIC PROCEDURE REM1 (LIS);
BEGIN SCALAR A;
  A := READCH ();       % kill last newline
  PROMPTEXP := "";              % kill off the prompt
  SETPCHAR (PROMPTEXP);
  WHILE LIS DO <<	% list of names to try for.
    PRIN2 (MYCAR (LIS));
    PRIN2 (":");
    SPACES (16 - FLATSIZE2 (MYCAR (LIS)));
    PRIN2 ("Delete? (Y/N/G/Q) ");	% prompt
    A := READCH ();
    IF NOT A = !$EOL!$ THEN READCH (); % newline

    IF A EQ 'Y THEN <<		% yes, kill it
      KILL (MYCAR (LIS));
      LIS := MYCDR (LIS)
    >>
    ELSE IF A EQ 'Q THEN LIS := 'NIL	% leave now, no more to do.
    ELSE IF A EQ 'G THEN <<	% go non-interactive a kill remaining.
      PRIN2 ("Are you sure? "); % check if user really wants this.
      A := READCH ();
      READCH ();
      IF A EQ 'Y THEN <<	% must answer 'y, or nothing happens.
        MAPCAR (LIS, 'KILL);
        LIS := 'NIL
      >>
    >>
    ELSE LIS := MYCDR (LIS)
  >>;
  WRITE (KILLED!*);
  TERPRI ();
  RETURN ('T);
END;

% kill is the primitive routine that removes indexed objects from the
% system by removing all properties and deleting the name from the inames
% list. if the object is kill-protected, kill will fail. kill removes the
% conjugate, covariant derivative, and all shifted offspring of any object
% it kills.
% Note: kill uses setplist to remove the property list. such a function
% does not exist in PSL.

SYMBOLIC PROCEDURE KILL (INP);
BEGIN SCALAR I, LEX;
  IF NOT INP THEN RETURN ('NIL);
  I := LOOK (INAMES, INP, 1)  OR 0;	% find name in inames list.
  IF ISPROTECT (INP, 3) THEN RETURN ('NIL);  % can't remove a protected name.
  INAMES := INSERT (INAMES, 'NIL, I, 'T);	% delete name
  IF NOT INDEXED (INP) THEN RETURN ('NIL);
  KILLED!* := INP . KILLED!*;	% list of deceased objects, printed by rem
  IF INDEXED (INP) EQ 'SCALAR THEN <<
    REMPROP (INP, 'SIMPFN);     % cautious kill. delete only 'tensor' props
    REMPROP (INP, 'INDEXED);    % and leave all others  (eg avalue).
    REMPROP (INP, 'INDICES);
    INDEXED (GET (INP, '!#DBR)) AND KILL (GET (INP, '!#DBR));
    REMPROP (INP, '!#DBR);
    GET (INP, 'TVALUE) AND SETK (INP, MK!*SQ (GET (INP, 'TVALUE)));
    REMPROP (INP, 'TVALUE);
  >> ELSE <<
    MAPCAR (MYCDDR (GET (INP, '!*AT!*)), 'KILL);  % wipe out offspring
    INDEXED (GET (INP, '!#DBR)) AND KILL (GET (INP, '!#DBR)); % and cov deriv.
    LEX := GET (INP, 'CONJUGATE);       % get conjugate name now, kill later
 					% (avoids a nasty loop)
    SETPROP (INP, 'NIL);			% remove all properties
    NOT MYCDR (LEX) AND KILL (MYCAR (LEX))	% kill conjugate (wont kill parent)
  >>;
  RETURN (INP);
END;

GLOBAL '(INAMES TITLE);
TITLE:= 'NIL;
PUT ('SAVEI, 'SIMPFN, 'SAVEI!*);
PUT ('SAVEC, 'SIMPFN, 'SAVEC!*);

% savei* saves indexed objects into a file in a form that allows them
% to be re-read in to the system as indexed objects (as opposed to
% savec, see below). the filename is the first argument, usually it is
% a string.

SYMBOLIC PROCEDURE SAVEI!* (U);
  IF MYCADR (U) EQ 'ALL THEN SAVEIC (MYCAR (U), 'SAVEI2,
        APPEND (REVERSE (INAMES), MYCDDR (U)))    % save everything
  ELSE SAVEIC (MYCAR (U), 'SAVEI2, MYCDR (U));

% savec* saves indexed objects in component form, see savec2 for a more
% complete description. the filename is the first argument.

SYMBOLIC PROCEDURE SAVEC!* (U);
  IF MYCADR (U) EQ 'ALL THEN SAVEIC (MYCAR (U), 'SAVEC2,
        APPEND (REVERSE (INAMES), MYCDDR (U)))	% save everthing.
  ELSE SAVEIC (MYCAR (U), 'SAVEC2, MYCDR (U));

GLOBAL '(SAVELIST!*);	% list of other things to be saved, i.e. the environment
SAVELIST!* := 'NIL;

GLOBAL '(LOADLIST);
LOADLIST := 'NIL;

% saveic calls the appropriate save routine for each object the user
% wishes to save. it also saves the environment of the system.

SYMBOLIC PROCEDURE SAVEIC (FILNME, FNC, LIS);
BEGIN SCALAR LEX, LEX1, FILEHANDLE;
  IF NOT (FILEHANDLE := OPEN (FILNME, 'OUTPUT)) THEN <<
    MERROR (LIST ("cannot open save file:", FILNME), 'NIL, 'SAVEIC);
    RETURN ('NIL)
  >>;
  WRITE !$EOL!$," Use lapin(";
  WRITECHAR (34);
  WRITE FILNME;
  WRITECHAR (34);
  WRITE ") to reload.",	!$EOL!$,!$EOL!$;
  WRS (FILEHANDLE);	% send output to save file.
  IF TITLE THEN <<
    PRIN2 ("(PRIN2 '");	% echo title when the file is loaded.
    PRIN1 (TITLE);
    PRIN2 (")");
    PRIN2 ("(TERPRI)");
    PRIN2(!$EOL!$)
  >>;
  PRIN2 ("(PRIN2 '");		% echo save date when file is loaded.
  PRIN1 (DATE ());
  PRIN2 (")");
  PRIN2 ("(TERPRI)");
  PRIN2 (!$EOL!$);  % newline
  IF (LEX := LOADLIST) THEN <<
    WHILE LEX DO <<
      IF (LEX1 := SUBSTRING (MYCAR (LEX),
                      FLATSIZE2 (MYCAR (LEX)) - 1, FLATSIZE2 (MYCAR (LEX))))
                    EQUAL ".sl" OR LEX1 EQUAL ".b" THEN <<
        PRIN2 ("(DSKIN ");
        PRIN1 (MYCAR (LEX));
        PRIN2 (")")
      >> ELSE << 
        PRIN2 ("(IN '(");
        PRIN1 (MYCAR (LEX));
        PRIN2 ("))")
      >>;
      LEX := MYCDR (LEX)
    >>;
    PRIN2(!$EOL!$)
  >>;
  FOR EACH X IN SAVELIST!* DO SAVEI2 (X, FILEHANDLE);
  FOR EACH X IN FINDKERN (LIS) DO SAVEI2 (X, FILEHANDLE);
  FOR EACH X IN LIS DO APPLY (FNC, LIST (X, FILEHANDLE));
  CLOSE (FILEHANDLE);
  WRS ('NIL);
  TERPRI ();
  RETURN (FILNME . 1);	% return file name
END;

% savei2 is the primitive routine which save indexed objects in their internal
% form so that they may be re-loaded into the system. to re-load requires
% calling the lisp LOAD function, not IN. this routine will save anything, not
% just indexed objects.

SYMBOLIC PROCEDURE SAVEI2 (EX, FILEHANDLE);
BEGIN;
  IF PROP (EX) THEN <<
    PRIN2 ("(SETPROP '");
    PRIN1 (EX);
    PRIN2 (" (UNIQKERN '");
    PRIN1 (PROP (EX));	% dump property list if it's there.
    PRIN2 ("))");
    PRIN2 (!$EOL!$)
  >>;
  IF NOT UNBOUNDP (EX) THEN <<	% if it has a value, dump this too.
    PRIN2 ("(SETQ ");
    PRIN1 (EX);
    PRIN2 (" (UNIQKERN '");
    PRIN1 (EVAL (EX));
    PRIN2 ("))");
    PRIN2 (!$EOL!$)
  >>;
  IF INDEXED (EX) THEN <<  % if it's indexed, make sure it gets back on inames.
    PRIN2 ("(AND (NOT (MEMQ '");
    PRIN2 (EX);
    PRIN2 (" INAMES)) (SETQ INAMES (CONS '");
    PRIN2 (EX);
    PRIN2 (" INAMES)))");
    PRIN2 (!$EOL!$);
  >>;
  PRIN2 ("(PRIN2 '");	% echo name when the file is loaded.
  PRIN1 (EX);
  PRIN2 (")");
  PRIN2 ("(SPACES 1)");
  PRIN2 (!$EOL!$);
  WRS ('NIL);
  WRITE (EX, " ");
  WRS (FILEHANDLE);
END;

% this routine saves indexed objects in component form, such objects cannot
% be reloaded as indexed objects. it creates names of the form
% <objname><index> for each element of the object and causes an assignment
% of the element to this name. e.g. q[0,1] will be save as q01.

SYMBOLIC PROCEDURE SAVEC2 (EX, FILEHANDLE);
BEGIN SCALAR LEX, LEX1, LEX2;
  IF NOT INDEXED (EX) THEN RETURN (SAVEI2 (EX, FILEHANDLE));
  LEX := GET (EX, 'TVALUE);
  LEX1 := GET (EX, 'MULTIPLIER);
  WHILE LEX DO <<	% save all elements in the 'tvalue, no implicit values.
    PRIN2 ("(SETK '");
    PRIN1 (IMPLODE (APPEND (EXPLODE (EX), 
           FOR EACH X IN MYCAAR (LEX) COLLECT (X + 48))));
    LEX2 := MK!*SQ (MULTSQ (LEX1, MYCDAR (LEX)));
    LEX := MYCDR (LEX);
    PRIN2 (" '");
    PRIN1 (LEX2);
    PRIN2 (")");
    PRIN2 (!$EOL!$)
  >>;
  WRS ('NIL);
  WRITE (EX, " ");
  WRS (FILEHANDLE);
END;

SYMBOLIC PROCEDURE UNIQKERN (U);
BEGIN SCALAR LEX;
  IF ATOM (U) THEN RETURN (U)
  ELSE IF ATOM (LEX := MYCAR (U)) THEN <<
    IF GET (LEX, 'KLIST) THEN <<    % operators MUST already exist!
      RETURN (CAR (FKERN (LEX . UNIQKERN (MYCDR (U)))))
    >>
    ELSE RETURN (LEX . UNIQKERN (MYCDR (U)))
  >> 
  ELSE RETURN (UNIQKERN (MYCAR (U)) . UNIQKERN (MYCDR (U)));
END;

FLUID '(KERNALS);
GLOBAL '(SYSOPS!*);
SYSOPS!* := '(T NIL DF ERF EXP EXPT DILOG ASIN ASINH ATAN ATANH COS COSH COT
              LOG SIN SINH SQRT TAN TANH);

SYMBOLIC PROCEDURE FINDKERN (U);
BEGIN SCALAR KERNALS;
  FOR EACH X IN U DO FINDKERN1 (X);
  RETURN (KERNALS);
END;

SYMBOLIC PROCEDURE FINDKERN1 (U);
<<
  FINDKERN2 (GET (U, 'TVALUE));
  FINDKERN2 (GET (U, 'AVALUE));
  IF FLAGP (U, 'SHARE) THEN FINDKERN2 (EVAL (U))
>>;

SYMBOLIC PROCEDURE FINDKERN2 (U);
BEGIN SCALAR LEX;
  IF ATOM (U) THEN RETURN ()
  ELSE IF IDP (LEX := MYCAR (U)) THEN <<
    IF (GET (LEX, 'KLIST) OR NOT GET (LEX, 'SIMPFN)) AND  % operator or var.
        NOT MEMQ (LEX, KERNALS) AND NOT MEMQ (LEX, SYSOPS!*) THEN
        KERNALS := LEX . KERNALS;
    FINDKERN2 (MYCDR (U))
  >> 
  ELSE <<
    FINDKERN2 (MYCAR (U));
    FINDKERN2 (MYCDR (U))
  >>;
END;

UNFLUID '(KERNALS);

GLOBAL '(!*NAT ALPHALIST!*);
PUT ('IAS, 'SIMPFN, 'IAS!*);

% ias allows the user to assign elements to an indexed object in a convenient
% fashion. it prompts for input for each possible element the object
% may have.

SYMBOLIC PROCEDURE IAS!* (U);
BEGIN SCALAR TNSR, LEX, LEX1, LIS, NATOLD;
  TNSR := MYCAR (U);
  IF NOT INDEXED (TNSR) OR ISPROTECT (TNSR, 2) THEN <<
    MERROR (LIST (TNSR, "cannot be assigned"), 'NIL, 'IAS);
    RETURN ('NIL . 1)
  >>;
      % list of all possible indices
  LEX := IGEN (HEAD (ALPHALIST!*, MYCAR (GET (TNSR, 'INDICES))),
               GET (TNSR, 'CONCOV), GET (TNSR, 'SYMMETRY));
  NATOLD := !*NAT;
  !*NAT := 'NIL;
  PROMPTEXP := "";              % kill off the prompt. for some reason psl
  SETPCHAR (PROMPTEXP);    % reduce prints the prompt when xread is called here
  WHILE LEX DO <<	% get values for each element
    MAPRINT (LIST ('RDR, TNSR, MYCAR (LEX)), 0); % print object and index
    PRIN2!* (" = ");
    TERPRI!* ('NIL);
    LEX1 := XREAD ('T);
    IF NOT LEX1 THEN LEX := 'NIL
    ELSE <<
      LEX1 := SIMP (LEX1);	% simplify input value
      IF NOT MYCAR (LEX1) AND NOT GET (TNSR, 'IMPLICIT) THEN LEX := MYCDR (LEX)
      ELSE <<		% if its not implicit, forget 0 values.
        LIS := (MYCAR (LEX) . LEX1) . LIS;
        LEX := MYCDR (LEX)
      >>
    >>
  >>;
  !*NAT := NATOLD;
  PUT (TNSR, 'TVALUE, REVERSE (LIS));
  RETURN (TNSR . 1);
END;

GLOBAL '(INAMES);
PUT ('COPY, 'SIMPFN, 'COPY!*!*);

SYMBOLIC PROCEDURE COPY!*!* (U);	% interface to copy*, this is dumb
  COPY!* (MYCAR (U), MYCADR (U));

% copy* is the routine which copies indexed objects.

SYMBOLIC PROCEDURE COPY!* (INN, OUTT);
BEGIN;
  INN := GETNME (REVAL (INN), 'COPY);
  OUTT := GETNME (REVAL (OUTT), 'COPY);
  IF NOT INDEXED (INN) THEN RETURN ('NIL . 1);
  IF GET (OUTT, 'PROTECTION) THEN
    MERROR (LIST ("output ", OUTT, " is protected"), 'T, 'COPY);
  KILL (OUTT);
  SETPROP (OUTT, SUBLIS ('((NIL . NIL)), PROP (INN)));	% force a copy of plist.
  INAMES := OUTT . INAMES;
  PUT (OUTT, 'PNAME, OUTT);
  PUT (OUTT, '!*AT!*, 'NIL);
  SET (OUTT, OUTT);		% so we can use unquoted name.
  RETURN (OUTT . 1);
END;

GLOBAL '(MAPBACK);	% place to save original value of object.
GLOBAL '(STCK);		% global list for storing mapped elements
PUT ('MAPFI, 'SIMPFN, 'MAPFI!*);

% mapfi* maps a function, (or just simp*) onto an indexed object, 
% rewriting that object. the original value is saved (along with the
% multiplier) in the global variable 'mapback above. the multipler
% of the object always becomes 1 after mapfi called.
% Either just the name of the object, or an object reference may be
% given, in which case simp!* is mapped. if a function call is made,
% then that function is used: eg mapfi (sub(r=a,f[a,s])); maps sub
% over all elements of f. neat eh!?

SYMBOLIC PROCEDURE MAPFI!* (U);
BEGIN SCALAR INN, OPRND, LEX, LEX1, LEX2, INDEX, INDICES, TVALUE, LINELNGTH;
  STCK := 'NIL;
  IF ATOM (INN := MYCAR (U)) THEN <<			% just the object name
    IF NOT INDEXED (INN) THEN RETURN (INN . 1);		% not indexed, no op
    INDICES := IGEN (INDEX := HEAD (ALPHALIST!*, MYCAR (GET (INN, 'INDICES))),
			GET (INN, 'CONCOV), GET (INN, 'SYMMETRY));
    OPRND := LIST ('EVALC, INN, INDEX)		% the value to simplify
  >> ELSE IF INDEXED (MYCAAR (U)) THEN <<		% a referenece
    INN := GETNME (LEX := REVAL (MYCAR (U)), 'MAPFI);	% name of object from reference
    IF NOT ATOM (LEX) AND MYCAR (LEX) EQ 'MINUS THEN LEX := MYCADR (LEX);
    INDICES := IGEN (INDH (MYCADDR (LEX)), 	% indices requested
		GET (INN, 'CONCOV), GET (INN, 'SYMMETRY));
    OPRND := LIST ('EVALC, INN, HEAD (ALPHALIST!*, 	% value to simp
			MYCAR (GET (INN, 'INDICES))))
  >> ELSE <<					% function call
    U := MYCAR (U);			
    WHILE U DO <<			% look for indexed object
      IF ATOM (MYCAR (U)) AND INDEXED (INN := MYCAR (U)) THEN << % just the object name
        INDICES := IGEN (INDEX := HEAD (ALPHALIST!*,
			MYCAR (GET (INN, 'INDICES))),
  			GET (INN, 'CONCOV), GET (INN, 'SYMMETRY));
        OPRND := APPEND (REVERSE (OPRND), LIST ('EVALC, INN, INDEX) . MYCDR (U));
        U := 'NIL   		% clear u to get out of loop

      >> ELSE IF NOT ATOM (MYCAR (U)) AND INDEXED (MYCAAR (U)) THEN <<	% a referenece
        INN := GETNME (LEX := REVAL (MYCAR (U)), 'MAPFI);
        IF MYCAR (LEX) EQ 'MINUS THEN LEX := MYCADR (LEX);
        INDICES := IGEN (INDH (MYCADDR (LEX)),
  			GET (INN, 'CONCOV), GET (INN, 'SYMMETRY));
        OPRND := APPEND (REVERSE (OPRND), LIST ('EVALC, INN,
				HEAD (ALPHALIST!*,
                                MYCAR (GET (INN, 'INDICES)))) . MYCDR (U));
        U := 'NIL		% clear u to get out of loop
      
      >>;
      OPRND := MYCAR (U) . OPRND;		% push car of u onto oprnd to save
      U := MYCDR (U)
    >>;
    OPRND := MYCDR (OPRND)		% lose a nil at the front
  >>;
  MAPBACK := LIST (TVALUE := GET (INN, 'TVALUE),		% save object
                   GET (INN, 'MULTIPLIER));
  SETLIS (ALPHALIST!*, ALPHALIST!*);	% clear
  LINELNGTH := LINELENGTH (100000);     % so print routines dont force wrap
  WHILE INDICES DO <<		% for each explicit element, apply function.
    IF MYCAR (INDICES) = MYCAAR (TVALUE) THEN <<   % element exists.
      PRIN2 ("
");		% print index
      PRIN1 (MYCAR (INDICES));
      FLUSHSTDOUTPUTBUFFER ();
      SETLIS (ALPHALIST!*, MYCAR (INDICES));
      LEX2 := SIMP!* (LIST ('!*SQ, SIMP!* (OPRND), 'NIL));
      UNSAVE ();		% clear alglist!*

      IF GET (INN, 'IMPLICIT) OR MYCAR (LEX2) THEN
        STCK := (MYCAR (INDICES) . LEX2) . STCK;
      INDICES := MYCDR (INDICES);
      TVALUE := MYCDR (TVALUE)
    >> ELSE IF NOT ASSOC (MYCAR (INDICES), TVALUE) THEN  	% skip index
       INDICES := MYCDR (INDICES)
    ELSE <<		% read out other elements to get multiplier out too
      STCK := (MYCAAR (TVALUE) . READTNSR (INN, MYCAAR (TVALUE))) . STCK;
      TVALUE := MYCDR (TVALUE)
    >>
  >>;
  LINELENGTH (LINELNGTH);
  SETLIS (ALPHALIST!*, ALPHALIST!*);
  WHILE TVALUE DO <<	% read out remaining elements to get multiplier
    STCK := (MYCAAR (TVALUE) . READTNSR (INN, MYCAAR (TVALUE))) . STCK;
    TVALUE := MYCDR (TVALUE)
  >>;
  PUT (INN, 'TVALUE, REVERSE (STCK));	% place new value
  PUT (INN, 'MULTIPLIER, 1 . 1);	% clear multiplier
  RETURN (INN . 1);
END;

FLUID '(COORDS);
GLOBAL '(INDICETEN);

PUT ('MKCOORDS, 'SIMPFN, 'MKCOORDS!*);

% mkcoords* sets up the call to mkcoords.

SYMBOLIC PROCEDURE MKCOORDS!* (U);
  MKCOORDS (MYCAR (U), MYCADR (U)) . 1;

% mkcoords constructs a vector from the coordinates list, primarily for
% use by the derivative routines, although the user can call it too.
% if crds is non-'nil, then this coordinate list is used instead of the
% global one. 

SYMBOLIC PROCEDURE MKCOORDS (TNSR, CRDS);
BEGIN SCALAR I, LEX;
  MKTNSR!* (TNSR, LIST (1), 'NIL, 'NIL, 'COORDINATES);
  CRDS := CRDS OR COORDS;
  PUT (TNSR, 'COORDS, CRDS);
  I := MYCAR (INDICETEN);
  LEX := COORDS;
  WHILE LEX DO <<	% place each element
    WRITETNSR (TNSR, LIST (I), SIMP (MYCAR (LEX)), 'T);
    LEX := MYCDR (LEX);
    I := I + 1
  >>;
  RETURN (TNSR);
END;

PUT ('DELTA, 'SIMPFN, 'DELTA!*);

% delta* creates the delta function (really an indexed object) for the 
% type of index given as the second argument. this function really doesn't
% need to be user callable since the system sets up its own delta functions
% when sys.env is read-in. these objects are not seen in the inames list.

SYMBOLIC PROCEDURE DELTA!* (U);
BEGIN SCALAR TNSR, EX, LEX, LEX1;
  TNSR := GETNME (MYCAR (U), 'DELTA);
  IF (EX := MYCADR (U)) THEN EX := ABS (EX)
  ELSE EX := 1;	% default is a tensor delta.	
  MKTNSR!* (TNSR, LIST (EX, -EX), '(((0) 1 2)), 1, 'DELTA);
  LEX := MKTNSR!* (MAKENAME (APPEND (EXPLODE (TNSR), '(!# c))),
                LIST (EX, EX), '(((0) 1 2)), 1, 'DELTAU);   % make offspring
  LEX1 := MKTNSR!* (MAKENAME (APPEND (EXPLODE (TNSR), '(!# d))),
                LIST (-EX, -EX), '(((0) 1 2)), 1, 'DELTAD);
  PROTECT!* (TNSR, 'W);
  PROTECT!* (LEX, 'W);
  PROTECT!* (LEX1, 'W);
  PUT (TNSR, 'COORDS, 'NIL);
  PUT (LEX, 'COORDS, 'NIL);
  PUT (LEX1, 'COORDS, 'NIL);
  PUT (LEX, 'PNAME, TNSR);
  PUT (LEX1, 'PNAME, TNSR);
  PUT (TNSR, '!*AT!*, LIST ('T, TNSR, LEX, LEX1));
  RETURN (TNSR . 1);
END;

PUT ('MULTIPLIER, 'SIMPFN, 'MULTIPLIER!*);

% multiplier* allows the user easy access to read or replace
% the multiplier of an indexed object.

SYMBOLIC PROCEDURE MULTIPLIER!* (U);
  RESIMPSCALAR (MYCADR (U), MYCAR (U), 'MULTIPLIER);

;END;
