/*
 * Copyright (C) 1992, Board of Trustees of the University of Illinois.
 *
 * Permission is granted to copy and distribute source with out fee.
 * Commercialization of this product requires prior licensing
 * from the National Center for Supercomputing Applications of the
 * University of Illinois.  Commercialization includes the integration of this 
 * code in part or whole into a product for resale.  Free distribution of 
 * unmodified source and use of NCSA software is not considered 
 * commercialization.
 *
 */


#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/Shell.h>
#include <Xm/Xm.h>
#include <Xm/DrawingA.h>
#include <X11/StringDefs.h>

#include "splash.h"


#define DEF_DEPTH	DefaultDepth(myDpy, DefaultScreen(myDpy))
#define DEF_CMAP	DefaultColormap(myDpy, DefaultScreen(myDpy))
#define DEF_BLACK	BlackPixel(myDpy, DefaultScreen(myDpy))
#define DEF_WHITE	WhitePixel(myDpy, DefaultScreen(myDpy))
#define DEF_ROOT	DefaultRootWindow(myDpy)


extern Display *myDpy;


Widget		intro_shell;



static GC		pixGC;
static Visual		*vis;
static int		NumCells;



XImage *BitmapToImage(width, height, data)
unsigned int width, height;
unsigned char *data;
{
	int linepad, shiftnum;
	int shiftstart, shiftstop, shiftinc;
	int bytesperline;
	int depth, temp;
	int w, h;
	Pixmap newpix;
	XImage *newimage;
	unsigned char *bit_data, *bitp, *datap;

	depth = DefaultDepth(myDpy, DefaultScreen(myDpy));
	if ((depth != 1)&&(depth != 2)&&(depth != 4)&&(depth != 8))
	{
		fprintf(stderr, "Don't know how to format image for display of depth %d\n", depth);
		return(NULL);
	}
	if (BitmapBitOrder(myDpy) == LSBFirst)
	{
		shiftstart = 0;
		shiftstop = 8;
		shiftinc = depth;
	}
	else
	{
		shiftstart = 8 - depth;
		shiftstop = -depth;
		shiftinc = -depth;
	}
	linepad = 8 - (width % 8);
	bit_data = (unsigned char *)XtMalloc(((width + linepad) * height) + 1);
	bitp = bit_data;
	datap = data;
	*bitp = 0;
	shiftnum = shiftstart;
	for (h=0; h<height; h++)
	{
		for (w=0; w<width; w++)
		{
			temp = *datap++ << shiftnum;
			*bitp = *bitp | temp;
			shiftnum = shiftnum + shiftinc;
			if (shiftnum == shiftstop)
			{
				shiftnum = shiftstart;
				bitp++;
				*bitp = 0;
			}
		}
		for (w=0; w<linepad; w++)
		{
			shiftnum = shiftnum + shiftinc;
			if (shiftnum == shiftstop)
			{
				shiftnum = shiftstart;
				bitp++;
				*bitp = 0;
			}
		}
	}
	bytesperline = (width + linepad) * depth / 8;
	newimage = XCreateImage(myDpy, vis, (unsigned int)depth, ZPixmap, 0,
		(char *)bit_data,
		(width + linepad), height, 8, bytesperline);

	return(newimage);
}



void FindColor(colr)
XColor *colr;
{
	int i;
	double rd, gd, bd, dist, mindist;
	int cindx;
	XColor def_colrs[256];

	for (i=0; i<NumCells; i++)
	{
		def_colrs[i].pixel = i;
	}
	XQueryColors(myDpy, DEF_CMAP, def_colrs, NumCells);
	mindist = 65536.0 * 65536.0;
	cindx = colr->pixel;
	for (i=0; i<NumCells; i++)
	{
		rd = (def_colrs[i].red - colr->red) / 256.0;
		gd = (def_colrs[i].green - colr->green) / 256.0;
		bd = (def_colrs[i].blue - colr->blue) / 256.0;
		dist = (rd * rd * rd * rd) + (gd * gd * gd * gd) + (bd * bd * bd *bd);
		if (dist < mindist)
		{
			mindist = dist;
			cindx = def_colrs[i].pixel;
		}
	}
	colr->pixel = cindx;
	colr->red = def_colrs[cindx].red;
	colr->green = def_colrs[cindx].green;
	colr->blue = def_colrs[cindx].blue;
}



void
ConvertColors(data, width, height, colrs)
	unsigned char *data;
	unsigned int width, height;
	XColor *colrs;
{
	unsigned char *tptr;
	int Mapping[256];
	int Used[256];
	int i, j;
	int ret;

	for (i=0; i<256; i++)
	{
		Used[i] = 0;
	}
	tptr = data;
	for (j=0; j<height; j++)
	{
		for (i=0; i<width; i++)
		{
			Used[(int)*tptr] = 1;
			tptr++;
		}
	}
	for (i=0; i<NumCells; i++)
	{
		if (Used[i] == 1)
		{
			ret = XAllocColor(myDpy, DEF_CMAP, &colrs[i]);
			if (ret != 1)
			{
				FindColor(&colrs[i]);
			}
			Mapping[i] = colrs[i].pixel;
		}
	}
	tptr = data;
	for (j=0; j<height; j++)
	{
		for (i=0; i<width; i++)
		{
			*tptr = (unsigned char)Mapping[(int)*tptr];
			tptr++;
		}
	}
}



void
Intro(top)
	Widget top;
{
	int i;
	Arg arg[10];
	Cardinal argcnt;
	Widget view;
	Pixmap pix;
	XImage *theImage;
	unsigned char *pic_data;
	unsigned int width, height;
	XColor colrs[256];

	vis = DefaultVisual(myDpy, DefaultScreen(myDpy));
	NumCells = DisplayCells(myDpy, DefaultScreen(myDpy));

	width = splash_width;
	height = splash_height;
	for (i=0; i<splash_colors; i++)
	{
		colrs[i].red = splash_reds[i];
		colrs[i].green = splash_greens[i];
		colrs[i].blue = splash_blues[i];
		colrs[i].pixel = i;
		colrs[i].flags = DoRed|DoGreen|DoBlue;
	}
	for (i=splash_colors; i<256; i++)
	{
		colrs[i].red = 0;
		colrs[i].green = 0;
		colrs[i].blue = 0;
		colrs[i].pixel = i;
		colrs[i].flags = DoRed|DoGreen|DoBlue;
	}
	pic_data = splash_raster;

	ConvertColors(pic_data, width, height, colrs);
	theImage = BitmapToImage(width, height, pic_data);

	pixGC = XCreateGC(myDpy, DEF_ROOT, 0, NULL);
	XSetFunction(myDpy, pixGC, GXcopy);
	pix = XCreatePixmap(myDpy, DEF_ROOT, width, height, DEF_DEPTH);
	XPutImage(myDpy, pix, pixGC, theImage, 0, 0, 0, 0, width, height);
	XDestroyImage(theImage);

        argcnt = 0;
        XtSetArg(arg[argcnt], XmNallowShellResize, True); argcnt++;
        XtSetArg(arg[argcnt], XmNkeyboardFocusPolicy, XmPOINTER); argcnt++;
        XtSetArg(arg[argcnt], XmNdeleteResponse, XmUNMAP); argcnt++;
        intro_shell = XtCreatePopupShell("Intro", transientShellWidgetClass,
			top, arg, argcnt);

	argcnt = 0;
	XtSetArg(arg[argcnt], XmNwidth, width); argcnt++;
	XtSetArg(arg[argcnt], XmNheight, height); argcnt++;
	XtSetArg(arg[argcnt], XmNbackgroundPixmap, pix); argcnt++;
	view = XmCreateDrawingArea(intro_shell, "View", arg, argcnt);
	XtManageChild(view);

	XtPopup(intro_shell, XtGrabNone);
}


void
CBIntroDone(w, client_data, event)
	Widget w;
	caddr_t client_data;
	XEvent *event;
{
	XtPopdown(intro_shell);
	XtRemoveEventHandler(w, ExposureMask, 0, CBIntroDone, (caddr_t)NULL);
}

