
#include <gl/image.h>
#include "rtep.h"

/***************************************************************************/
/* FUNCTION: int irisimg_io()
/*
/* DESCRIPTION:
/*    Returns the dimensions of an image in "iris" image format.
/*
/* USAGE:
/*    error_ret = iris_getdims(imgfile,xsiz,ysiz,zsiz);
/*
/* ARGUMENTS:
/*    char           *imgname   (in)     : filename of image
/*    int            *xsiz      (in/out) : X dimension of image
/*    int            *ysiz      (in/out) : Y dimension of image
/*    int            *zsiz      (in/out) : Z dimension of image [1 or 3]
/*
/* RETURNS: (int)
/*    0 : function call completed successfully
/*    1 : i/o open error
/*
/* COMMENTS:
/*    The "iris" image file format is supported by the /usr/lib/libimage.a
/*    C subroutine library on SGI IRIS 4D/?? series workstations.  The
/*    include file <gl/image.h> is necessary when using these subroutines.
/*    The variable 'zsiz' refers to the number of byte-planes, i.e. 
/*    zsiz=1 would correspond to an 8-bit per pixel image, and zsiz=3
/*    would correspond to a 24-bit per pixel image.
/*
/* EXAMPLE:
/* SEE ALSO:
/*    irisimg_io()
/*
/* INFO:
/*    Author : Ray Idaszak
/*    Date   : March 1, 1989
/*    email  : rayi@ncsa.uiuc.edu
/***************************************************************************/

int iris_getdims(imgfile,xsiz,ysiz,zsiz)
char *imgfile;
int *xsiz,*ysiz,*zsiz;
{
	IMAGE *image;
	int err_ret;

	err_ret = 0;

	if ( (image=iopen(imgfile,"r")) == NULL){
		err_ret = 1;
		goto error;
	}

	*xsiz = image->xsize;
	*ysiz = image->ysize;
	*zsiz = image->zsize;

	iclose(image);

error:
#if RTE_PRERR
	err_msg("iris_getdims",err_ret);
#endif
	return(err_ret);
}
