/*
# proc:  buildprototree_wrap - C wrapper around a fortran routine. Takes features
# proc:                        and classes, sets up params and builds the tree.
*/

#define MN 40000
#define MC     3
#define MP    14

#include <stdio.h>
#include <stdlib.h>

buildprototree_wrap(feats, class, nPats, nInps, child, idiscr,
                    npts, ipts, vmin, vmax, nnodes, nchild)
float *feats, **vmin, **vmax;
int   nPats, nInps, *nnodes, *nchild;
int   *class, **child, **idiscr, **npts, **ipts;
{
int maxnodes, minpln;
int *parent, *src, *dst, j, k, m;

      maxnodes = MN; minpln = MP; *nchild = MC;

      m = maxnodes * *nchild;
      if ((*child = (int   *)malloc(m * sizeof(int  ))) == NULL)
         syserr("buildprototree_wrap", "malloc", "space for child");
      m = maxnodes;
      if ((parent = (int   *)malloc(m * sizeof(int  ))) == NULL)
        syserr("knn pdriver", "malloc", "space for parent");
      if ((*idiscr= (int   *)malloc(m * sizeof(int  ))) == NULL)
         syserr("buildprototree_wrap", "malloc", "space for idiscr");
      if ((*npts  = (int   *)malloc(m * sizeof(int  ))) == NULL)
         syserr("buildprototree_wrap", "malloc", "space for npts");
      if ((*ipts  = (int   *)malloc(m * sizeof(int  ))) == NULL)
         syserr("buildprototree_wrap", "malloc", "space for ipts");
      if ((*vmin  = (float *)malloc(m * sizeof(float))) == NULL)
         syserr("buildprototree_wrap", "malloc", "space for vmin");
      if ((*vmax  = (float *)malloc(m * sizeof(float))) == NULL)
         syserr("buildprototree_wrap", "malloc", "space for vmax");

      buildprototree_(feats, class, &nPats, &nInps, parent, *child,
                      *idiscr, *npts, *ipts, *vmin, *vmax,
                      &maxnodes, nnodes, nchild, &minpln);

      /* compress the data within its allocated space so that we   */
      /* only need to write the first nnodes <= maxnodes to a file */
      /* if the fortran tree classification routine is called with */
      /* the child array from this routine it will not work        */
      /* C on the other hand will be fine. 			   */
      for ( j = 0, src = *child, dst = *child ; j < *nchild ; j++ )
      {  
         for ( k = 0 ; k < *nnodes ; k++ )
            *dst++ = *src++;
         src += maxnodes - *nnodes;
      }
      free(parent);
}
