/*
# proc: find_pi_lists - given a list of segmented character centers, sorts the
# proc:                 blob indices into phrases according to proper reading
# proc:                 order.
*/

#include <stdio.h>

/***************************************************************************/
find_pi_lists(pi_lists, pi_lens, nphrases,
             hmean, prevmeanfactor, meanfactor, slopethresh,
             omxs, omys, all, pa1, b1, pa2, b2,  abegin, alimit)
int *pi_lists[], *pi_lens;
int *nphrases, *omxs, *omys, all;
float hmean, prevmeanfactor, meanfactor, slopethresh, abegin, alimit;
float pa1, b1, pa2, b2;
{
   int i;
   float succlimit;
   float curdelta, a1, a2, prevdelta, dist;
   float abm, ylimit, compute_slope(), find_bubble_max_y();
   int near_i, px, py, pi, end;
   int prevx, prevy, prevflag;
   float na, nb;
   int *mxs, *mys, *pis;

   end = all;

   if((mxs = (int *)calloc(all, sizeof(int))) == NULL)
      syserr("find_pi_lists", "calloc", "mxs");
   memcpy(mxs, omxs, all*sizeof(int));
   if((mys = (int *)calloc(all, sizeof(int))) == NULL)
      syserr("find_pi_lists", "calloc", "mys");
   memcpy(mys, omys, all*sizeof(int));
   if((pis = (int *)calloc(all, sizeof(int))) == NULL)
      syserr("find_pi_lists", "calloc", "pis");

   for(i = 0; i < all; i++){
      pis[i] = i;
   }

   succlimit = prevmeanfactor * hmean;
   a1 = pa1 * hmean;
   a2 = pa2 * hmean;
   abm = compute_slope(a1, b1, a2, b2);

   ylimit = find_bubble_max_y(alimit, a1, b1, abm);

   new_pi_list(&pi, &px, &py, &prevdelta, &prevflag,
               pi_lists, pi_lens, nphrases, pis, mxs, mys, &end,
               abm, a1, b1, abegin, alimit, ylimit);
   all--;

   while (all > 0){
      near_i = -1;
      nearest_nbor_in_right_bubble(&near_i, &dist, &na, &nb,
                       px, py, mxs, mys, end, abm, a1, b1,
                       abegin, alimit, ylimit);
      if(near_i == -1){
         new_pi_list(&pi, &px, &py, &prevdelta, &prevflag, 
                     pi_lists, pi_lens, nphrases, pis, mxs, mys, &end,
                     abm, a1, b1, abegin, alimit, ylimit);
         all--;
      }
      else{
         if(prevflag){
            curdelta = (float)(prevy - mys[near_i]);
            current_pi_list(na, nb, near_i, curdelta,
                  &px, &py, &prevx, &prevy,
                  &prevdelta, &prevflag, succlimit,
                  pi_lists, pi_lens, nphrases,
                  hmean, meanfactor, slopethresh,
                  pis, mxs, mys, &end,
                  abm, a1, b1, abegin, alimit, ylimit);
            all--;
         }
         else{
            curdelta = (float)(py - mys[near_i]);
            current_pi_list(na, nb, near_i, curdelta,
                  &px, &py, &prevx, &prevy,
                  &prevdelta, &prevflag, succlimit,
                  pi_lists, pi_lens, nphrases,
                  hmean, meanfactor, slopethresh,
                  pis, mxs, mys, &end,
                  abm, a1, b1, abegin, alimit, ylimit);
            all--;
         }
      }

   }
   free(mxs);
   free(mys);
   free(pis);
}
