.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DdInqExtent 3D  "Dore"
.SH NAME
DdInqExtent \- Return the extent of a device
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
void DdInqExtent(device, volume)
DtObject device;
DtVolume *volume;
.sp
.in -.5i
FORTRAN:
.in +.5i
CALL DDQE(DEVICE, VOLUME)
INTEGER*4 DEVICE
REAL*8 VOLUME(6)
.in -.5i
.fi
.SH DESCRIPTION
.IX DDQE
.IX DdInqExtent
.I DdInqExtent
gets the volume range available to an indicated device, \f2device\fP.
It returns the x,y,z values for the back
lower left and the front upper right coordinates
of the volume range.
.SH ERRORS
.I DdInqExtent
will fail if the device handle is invalid.
.TP 15
[WARNING - invalid device handle]
.SH "SEE ALSO"
.na
.nh
DdInqViewport(3D), DdInqResolution(3D), DdInqVisualType(3D),
DoDevice(3D)
.ad
.hy
