.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DdInqFonts 3D  "Dore"
.SH NAME
DdInqFonts \- Return the set of fonts supported by a device
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
void DdInqFonts(device, fonts)
DtObject device;
DtFontPrecision fonts[\|];
.sp
.in -.5i
FORTRAN:
.in +.5i
CALL DDQFT(DEVICE, FONTS)
INTEGER*4 DEVICE
INTEGER*4 FONTS(*)
.in -.5i
.fi
.SH DESCRIPTION
.IX DDQFT
.IX DdInqFonts
.I DdInqFonts
returns the set of fonts supported on \f2device\fP
in the user-supplied array \f2fonts\fP.
The array \f2fonts\fP consists of a set of pairs.  Each pair specifies a
font identifier and a corresponding precision.  The possible values for
the text precision are: \f2DcStringPrecision\fP <\f2DCSTRP\fP>,
\f2DcCharacterPrecision\fP <\f2DCCHRP\fP>, and
\f2DcStrokePrecision\fP <\f2DCSTKP\fP>.
Stroke precision is considered the most complex, and string precision is
considered the least complex.
If a font is available at a specified precision, it is also
available at all lower precisions.
.SH ERRORS
.I DdInqFonts
will fail if the device handle is invalid.
.TP 15
[WARNING - invalid device handle]
.SH "SEE ALSO"
DdInqNumFonts(3D), DoTextFont(3D)
