.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DdInqPickAperture 3D  "Dore"
.SH NAME
DdInqPickAperture \- Return the pick aperture of a device
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
void DdInqPickAperture(device, aperture)
DtObject device;
DtSize3 *aperture;
.sp
.in -.5i
.BP
FORTRAN:
.in +.5i
CALL DDQPA(DEVICE, APRTUR)
INTEGER*4 DEVICE
REAL*8 APRTUR(3)
.in -.5i
.fi
.SH DESCRIPTION
.IX DDQPA
.IX DdInqPickAperture
.I DdInqPickAperture
returns the pick aperture of a specified device, \f2device\fP, into the
\f2width\fP, \f2height\fP, and \f2depth\fP fields of the supplied
FORTRAN, the aperture is returned
in an array>.
.PP
When a pick is initiated on a device (via \f2DdPickObjs\fP <\f2DDPO\fP>),
a volume of space centered around the pick point is searched for
drawable objects.
The dimensions of that volume are defined by the device's pick
aperture as specified by a width, a height, and a depth in device
coordinates.  The pick aperture is set by \f2DdSetPickAperture\fP
<\f2DDSPA\fP>.
.SH ERRORS
.I DdInqPickAperture
will fail if passed an invalid device handle.
.TP 15
[WARNING - invalid device handle]
.SH "SEE ALSO"
DdPickObjs(3D), DdSetPickAperture(3D)
