.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DdInqShadeMode 3D  "Dore"
.SH NAME
DdInqShadeMode \- Return the shade mode of a device
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
DtShadeMode DdInqShadeMode(device)
DtObject device;
.sp
.in -.5i
FORTRAN:
.in +.5i
INTEGER*4 DDQSM(DEVICE)
INTEGER*4 DEVICE
.in -.5i
.fi
.SH DESCRIPTION
.IX DDQSM
.IX DdInqShadeMode
.I DdInqShadeMode
returns the shade mode of a device, \f2device\fP.
.PP
Dore can produce output on devices that have limited color capability.
These devices are usually referred to as "pseudocolor" devices.
Dore always computes shades in full color, and compresses these shades to
pseudocolor for output.
.PP
The shade mode specifies how this compression is performed.
The possible values for the shade mode are:
.IP "\f2DcComponent\fP <\f2DCCOMP\fP>"
Each primary computed color (red, green, and blue) is
compressed into a limited bit range. 
The resulting bit fields are combined by 
a bitwise \f2or\fP operation to produce a single
value of \f2n\fP bits.
Each value of \f2n\fP has a specific compression algorithm; for example, if \f2n\fP = 8,
3 bits are red, 3 bits are green, and 2 bits
are blue.
.IP "\f2DcRange\fP <\f2DCRNG\fP>"
The user has loaded a color map containing
specific ranges of shading (for example, gold or 
silver) into the pseudocolor device.
The \f2DdInqShadeRanges\fP <\f2DDQSR\fP> and
\f2DdSetShadeRanges\fP <\f2DDSSR\fP> calls
inquire and set up the contents of specific shade ranges.
See the manual pages for those calls for further
information on this pseudocolor mode. 
.SH ERRORS
.I DdInqShadeMode
will fail if the device handle is invalid; the returned value is undefined.
.TP 15
[WARNING - invalid device handle]
.PP
.SH "SEE ALSO"
.na
.nh
DdInqColorEntries(3D), DdInqColorTableSize(3D), DdInqShadeRanges(3D), 
DdInqVisualType(3D), DdSetColorEntries(3D), DdSetShadeMode(3D),
DdSetShadeRanges(3D), DoShadeIndex(3D), DoDevice(3D)
.ad
.hy
