.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DdSetColorEntries 3D  "Dore"
.SH NAME
DdSetColorEntries \- Set the color lookup table entries of a device
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
void DdSetColorEntries(device, colormodel, start, count, 
		entries)
DtObject device;
DtColorModel colormodel;
DtInt start;
DtInt count;
DtReal entries[\|];
.sp
.in -.5i
FORTRAN:
.in +.5i
CALL DDSCE(DEVICE, COLMOD, START, COUNT, 
		ENTRYS)
INTEGER*4 DEVICE
INTEGER*4 COLMOD
INTEGER*4 START
INTEGER*4 COUNT
REAL*8 ENTRYS(*)
.in -.5i
.fi
.SH DESCRIPTION
.IX DDSCE
.IX DdSetColorEntries
.I DdSetColorEntries
sets the color entries in the color lookup table of a 
pseudocolor device, \f2device\fP, starting at the \f2start\fP
location for \f2count\fP number of entries in the array, \f2entries\fP.
Many actual devices use a color lookup table or a fixed set of colors
or grey values.  \f2DdSetColorEntries\fP allows the user to specify
a set of colors for these tables if they are user-writable.
Use \f2DdInqVisualType <DDQVT>\fP to determine whether a device
has user-writable tables.
The valid visual types are \f2DcGreyScale\fP <\f2DCGRYS\fP>,
\f2DcDirectColor\fP <\f2DCDRCC\fP>, and
\f2DcPseudoColor\fP <\f2DCPSUC\fP>:
.PP
.IP "\f2DcPseudoColor\fP <\f2DCPSUC\fP>"
A pixel value indexes a color map to determine
the color to be displayed; the entries in the color map can be changed
dynamically.
.IP "\f2DcGreyScale\fP <\f2DCGRYS\fP>"
These devices are the same as pseudocolor devices,
except that only the intensities of the entries specified in the lookup table
are displayed.
.IP "\f2DcDirectColor\fP <\f2DCDRCC\fP>"
A pixel value is decomposed into separate subfields,
and each subfield separately indexes the color map for the corresponding value.
The entries in the color map can be changed dynamically.
Typically, the color map is used for displaying false color or
for performing gamma correction.
.IP "\f2colormodel\fP"
Specifies the color model of the colors in the array \f2entries\fP.
.IP "\f2start\ \ \ \ \fP"
Specifies the beginning entry.
.IP "\f2count\fP"
Specifies the total number of colors to be set.
.IP "\f2entries\fP"
The array of values for the kind of color specified by \f2colormodel\fP.  For
example, \f2entries\fP of color values for \f2colormodel\fP \f2DcRGB\fP
<\f2DCRGB\fP> would take three components:
a red value, a green value, and a blue value.
.SH ERRORS
.I DdSetColorEntries
will fail if the device handle is invalid.
.TP 15
[WARNING - invalid device handle]
.PP
\f2DdSetColorEntries\fP will fail if the \f2start\fP or \f2count\fP parameters
refer to entries outside the color lookup table boundaries.
.TP 15
[WARNING - bad start and/or count values]
.SH "SEE ALSO"
.na
.nh
DdInqColorEntries(3D), DdInqColorTableSize(3D), 
DdInqVisualType(3D) 
.ad
.hy
