.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DdSetPickAperture 3D  "Dore"
.SH NAME
DdSetPickAperture \- Set the pick aperture of a device
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
void DdSetPickAperture(device, aperture)
DtObject device;
DtSize3 *aperture;
.sp
.in -.5i
FORTRAN:
.in +.5i
CALL DDSPA(DEVICE, APRTUR)
INTEGER*4 DEVICE
REAL*8 APRTUR(3)
.in -.5i
.fi
.SH DESCRIPTION
.IX DDSPA
.IX DdSetPickAperture
.I DdSetPickAperture
sets the pick aperture on a specified device, \f2device\fP, for use
during picking.
.PP
When a pick is initiated on a device (via \f2DdPickObjs\fP <\f2DDPO\fP>),
a volume of space centered around the pick point is searched for
drawable objects.
The dimensions of that volume define that device's pick aperture which
is always at right angles to the device.  The \f2width\fP,
\f2height\fP, and \f2depth\fP fields <three consecutive values in
FORTRAN array> are given in device coordinates where one
unit is the distance between adjacent pixel centers.
.SH ERRORS
.I DdSetPickAperture
will fail if passed an invalid device handle.
.TP 15
[WARNING - invalid device handle]
.SH DEFAULTS
The default pick aperture, in x,y,z format, 
is 10.0 by 8.0 by 4 * (entire Z depth of
the device viewport).
.SH "SEE ALSO"
DdInqViewport(3D), DdInqPickAperture(3D), DdPickObjs(3D)
