.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DeAddClass 3D "Dore"
.SH NAME
DeAddClass \- Add a user-defined class (object type)
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
DtInt DeAddClass(name, count, list, default_routine)
DtPtr name;
DtInt count;
DtMethodEntry list[\|];
DtMethodPtr default_routine;
.sp
.in  -.5i
FORTRAN:
.in  +.5i
INTEGER*4 DEAC(NAME, N, COUNT, LIST, DFLTRT)
CHARACTER*N NAME
INTEGER*4 COUNT
INTEGER*4 LIST(*)
EXTERNAL DFLTRT

DEAMTH(LIST, METHOD, RTN, MTHCNT)
INTEGER*4 LIST(*)
INTEGER*4 METHOD
EXTERNAL RTN
INTEGER*4 MTHCNT
.fi 
.SH DESCRIPTION
.IX DEAC
.IX DEAMTH
.IX DeAddClass
.PP
\f2DeAddClass\fP adds a new class (object type) to the Dore system. 
It returns a unique class identification number. 
.PP
Each class in Dore must have a unique name.  The parameter \f2name\fP
specifies the name for the new class.   The convention is to name the
class the same as the routine for creating an object of the new class.
.PP
The parameter \f2list\fP is an array of \f2DtMethodEntry\fP where each
entry is defined as:
.sp
typedef struct {
   DtInt       id;      /*Method Identifier*/
   DtMethodPtr routine; /*Pointer to Method Routine*/
} DtMethodEntry;
.sp
The array is used to associate user-defined method routines with
methods.
The parameter \f2count\fP specifies the number of methods in \f2list\fP.  
.PP
The parameter \f2default_routine\fP is a pointer to a routine
that will be used for methods that are not specified in \f2list\fP,
or \f2DcNullPtr\fP <\f2DCNULL\fP>.
.PP
Methods used by user-defined primitives are:
.IP "\f2DcMethodCmpBndVolume\fP\ \ \ <\f2DCMCBV\fP>"
Compute bounding volume box.
.IP "\f2DcMethodDestroy\fP\ \ \ <\f2DCMDST\fP>"
Deallocate space used by object.
.IP "\f2DcMethodDynRender\fP\ \ \ <\f2DCMDR\fP>"
Dynamic rendering, if different from \f2DcMethodStdRenderDisplay\fP.
.IP "\f2DcMethodGlbrndIniObjs\fP\ \ \ <\f2DCMGIO\fP>"
Production rendering, if different from\f2DcMethodStdRenderDisplay\fP.
.IP "\f2DcMethodPick\fP\ \ \ <\f2DCMPCK\fP>"
Determine if object has been picked.
.IP "\f2DcMethodPrint\fP\ \ \ <\f2DCMPRT\fP>"
Print object information.
.IP "\f2DcMethodStdRenderDisplay\f2 <\f2DCMSRD\fP>"
Update and execute alternate object.
.IP "\f2DcMethodUpdStdAltObj\fP <\f2DCMSAO\fP>"
Update and return alternate object.
.SH "FORTRAN SPECIFIC"
.LP
The parameter \f2NAME\fP is a string of length \f2N\fP representing the
name of the new class.
.LP
FORTRAN the method list is built using \f2DEAMTH\fP.
The calling routine must allocate space for the list (twice as many
elements as methods to be inserted).
\f2DEAMTH\fP is called once for every method/routine pair to be added 
to the list.
The parameter \f2MTHCNT\fP is the number of methods that have 
already been added to the list.
.SH ERRORS
.I DeAddClass
will fail if a method in \f2list\fP is invalid.
.TP 15
[WARNING - invalid method]
\&
