.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DeCreateObject 3D "Dore"
.SH NAME
DeCreateObject \- Create an internal Dore object
.SH SYNOPSIS
.nf
.ft 3 
C: 
.in  +.5i
DtObject DeCreateObject(class_id, object_data)
DtInt class_id; 
DtPtr object_data;
.sp
.in  -.5i
FORTRAN:
.in  +.5i
INTEGER*4 DECO(CLASID,DATA,SIZE)
INTEGER*4 CLASID
REAL*8 DATA(*)
INTEGER*4 SIZE
.fi 
.SH DESCRIPTION
.IX DECO
.IX DeCreateObject
.LP
\f2DeCreateObject\fP creates an internal Dore object, and returns the object
handle. It is used by implementations of user-defined classes.
.LP
The parameter \f2class_id\fP is the unique class identifier for  
the object to be created.  For user-defined classes this will be the class
identification number returned by \f2DeAddClass\fP <\f2DEAC\fP>.
.LP
.SH "C SPECIFIC"
.LP
The C version of \f2DeCreateObject\fP assumes that
the calling routine has already allocated space for the private data
for the object, and that \f2object_data\fP points to this data.
.SH "FORTRAN SPECIFIC"
.LP
FORTRAN function, \f2DECO\fP, assumes that space for the private
data has \f2not\fP been allocated.  
It will allocate \f2SIZE\fP bytes, and copy the
same number of bytes from \f2DATA\fP to the newly allocated
space.
This means that the method routines of a user-defined primitive
FORTRAN do not have direct access to the private
data of the objects.  The private data of those objects can be 
FORTRAN through calls to 
\f2DEROD\fP, \f2DEWOD\fP, and \f2DEDOD\fP.
.LP 
Note that the type of \f2DATA\fP is not important since 
\f2DECO\fP only uses the address of it as a starting point for the 
copy.  Typically, \f2DATA\fP will be an array containing
variables of different types (via an EQUIVALENCE statement).
.SH ERRORS
.I DeCreateObject
will fail if the class identifier is invalid.
.TP 15
[WARNING - invalid class handle]
.SH SEE ALSO
.nf
DeAddClass(3D), DEDOD(3D), DEROD(3D) DEWOD(3D)
.fi
\&
