.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DgInqObjAtPos 3D "Dore"
.SH NAME
DgInqObjAtPos \- Return the object at a specified position in a group
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
DtObject DgInqObjAtPos(group, offset,
                       position_orientation)
DtObject group ;
DtInt offset;
DtRelPosition position_orientation;
.sp
.in -.5i
FORTRAN:
.in +.5i
INTEGER*4 DGQOP(GROUP, OFFSET, POSORT)
INTEGER*4 GROUP
INTEGER*4 OFFSET
INTEGER*4 POSORT
.in -.5i
.fi
.SH DESCRIPTION
.IX DGQOP
.IX DgInqObjAtPos
.I DgInqObjAtPos
returns the object at the position, in \f2offset\fP, 
relative to the position in
\f2position_orientation\fP, and within the group \f2group\fP.
Positions within a group are zero based with element 0 being the first
element in the group and element \f2n-1\fP being
the last element in the group of
size \f2n\fP.
.PP
The \f2position_orientation\fP parameter can take one of the following values:
.IP "\f2DcBeginning\fP <\f2DCBEG\fP>"
The element pointer is positioned relative to the beginning of the group.
.IP "\f2DcEnd\fP <\f2DCEND\fP>"
The element pointer is positioned relative to the end of the group.
.IP "\f2DcCurrent\fP <\f2DCCUR\fP>"
The element pointer is positioned relative to the element pointer's current
position.
.PP
If no object is at the specified position,
then \f2DcNullObject\fP <\f2DCNULL\fP> is returned.
Otherwise, the object at the specified position is returned.
.SH ERRORS
.I DgInqObjAtPos
will fail if called with an invalid group; the value
\f2DcNullObject\fP <\f2DCNULL\fP> is returned.
.TP 15
[WARNING - invalid group handle]
