.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DoDiffuseColor 3D  "Dore"
.SH NAME
DoDiffuseColor \- Create a diffuse color primitive attribute object
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
DtObject DoDiffuseColor(colormodel, color)
DtColorModel colormodel;
DtReal color[\|];
.sp
.in -.5i
FORTRAN:
.in +.5i
INTEGER*4 DODIFC(COLMOD, COLOR)
INTEGER*4 COLMOD
REAL*8 COLOR(*)
.in -.5i
.fi
.SH DESCRIPTION
.IX DODIFC
.IX DoDiffuseColor
\f2DoDiffuseColor\fP creates a diffuse color primitive attribute
using the color model specified by \f2colormodel\fP.
The \f2color\fP parameter specifies the diffuse response of a
surface to light.
.PP
Diffuse reflectance is the response of a surface to incident (i.e.,
non-ambient) light where the emitted light is scattered equally in
all directions.  The diffuse color
of a surface is often thought of as the base color. As such, the 
diffuse color is also used for determining the color of the ambient
component of a surface.
.PP
The diffuse color is one of three aspects of the diffuse component of
a surface.  The other two components are \f2DoDiffuseIntens\fP <\f2DODIFI\fP>
and \f2DoDiffuseSwitch\fP <\f2DODIFS\fP>.
.SH DEFAULTS
The default \f2DoDiffuseColor\fP is (\f2DcRGB\fP, (1.0, 1.0, 1.0)).
.SH "SEE ALSO"
DoDiffuseIntens(3D), DoDiffuseSwitch(3D), DoAmbientIntens(3D),
DoAmbientSwitch(3D)
