.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DoEmissionColor 3D  "Dore"
.SH NAME
DoEmissionColor \- Create an emission color primitive attribute object
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
DtObject DoEmissionColor(colormodel, color)
DtColorModel colormodel;
DtReal color[\|];
.sp
.in -.5i
FORTRAN:
.in +.5i
INTEGER*4 DOEMIC(COLMOD, COLOR)
INTEGER*4 COLMOD
REAL*8 COLOR(*)
.in -.5i
.fi
.SH DESCRIPTION
.IX DOEMIC
.IX DoEmissionColor
.I DoEmissionColor
creates an emission color primitive attribute object.  The parameter
\f2colormodel\fP specifies the color model used.
The parameter \f2color\fP
specifies the color of the light emitted.
Emissive primitive objects are used as light sources in
radiosity calculations. 
.PP
The other aspects of the emission specification are the 
emission factor (set with \f2DoEmissionFactor <DOEMIF>\fP)
and the emission switch (set with \f2DoEmissionSwitch <DOEMIS>\fP).
.SH DEFAULTS
The default \f2DoEmissionColor\fP is (\f2DcRGB\fP, (1.0, 1.0, 1.0)).
.SH "SEE ALSO"
.na
.nh
DoEmissionFactor(3D),
DoEmissionSwitch(3D),
DoRadiositySwitch(3D)
.ad
.hy
