.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DoEmissionSwitch 3D  "Dore"
.SH NAME
DoEmissionSwitch \- Create a primitive attribute object for enabling or disabling emissivity
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
DtObject DoEmissionSwitch(switchvalue)
DtSwitch switchvalue;
.sp
.in -.5i
FORTRAN:
.in +.5i
INTEGER*4 DOEMIS(SWVAL)
INTEGER*4 SWVAL
.in -.5i
.fi
.SH DESCRIPTION
.IX DOEMIS
.IX DoEmissionSwitch
.I DoEmissionSwitch
creates a primitive attribute object
for enabling or disabling emissivity.
Emissive primitive objects are used as light sources for radiosity calculations.
For the primitive objects rendered using radiosity,
lights source objects in the studio group are ignored.
.PP
The parameter \f2switchvalue\fP specifies whether subsequent
primitive objects emit light. If the switch is \f2DcOn\fP <\f2DCON\fP>,
subsequent primitive objects are considered emissive.
The color of the emitted light is determined by \f2DoEmissionColor <DOEMIC>\fP,
and its intensity can be scaled using \f2DoEmissionFactor <DOEMIF>\fP.
Emissive objects are visible in a rendered scene.
.PP
If the emission switch is 
\f2DcOff\fP <\f2DCOFF\fP>, subsequent objects do not emit light.
.SH DEFAULTS
The default for \f2DoEmissionSwitch\fP is \f2DcOff\fP <\f2DCOFF\fP>.
.SH "SEE ALSO"
.na
.nh
DoEmissionColor(3D),
DoEmissionFactor(3D),
DoRadiositySwitch(3D),
DvSetRadiosityUpdateType(3D)
.ad
.hy
