.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DoLightSpreadAngles 3D "Dore"
.SH NAME
DoLightSpreadAngles \- Create a light attribute object defining the width of the light beam of spotlights
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
DtObject DoLightSpreadAngles(total_angle, delta_angle)
DtReal total_angle;
DtReal delta_angle;
.sp
.in  -.5i
FORTRAN:
.in  +.5i
INTEGER*4 DOLTSA(TANGLE, DANGLE)
REAL*8 TANGLE
REAL*8 DANGLE
.in  -.5i
.fi 
.IX "DoLightSpreadAngles"
.IX "DOLTSA"
.SH DESCRIPTION
.LP
\f2DoLightSpreadAngles\fP creates a light studio attribute object
that defines a multiplicative factor modifying the light intensity as
a function of the angle from the light direction.
The \f2DoLightSpreadAngles\fP attribute defines the light cone for 
lights of type \f2DcLightSpot\fP <\f2DCLTSP\fP> or
\f2DcLightSpotAttn\fP <\f2DCLTSA\fP>. 
.PP
The two angles \f2total_angle\fP and \f2delta_angle\fP
are measured away from the light direction.
.PP
\f2DoLightSpreadAngles\fP actually defines two cones of
light.
Anywhere within the center cone (\f2total_angle\fP minus
\f2delta_angle\fP), the factor takes on the full intensity
value (1.0).
Anywhere outside the outer cone defined by \f2total_angle\fP,
the factor is set to zero.
Between the two cones, the value of the factor
falls off gradually from 1.0 to 0.0.
.PP
The angles \f2total_angle\fP and \f2delta_angle\fP
are, by default, expressed in radians.
You can change the units to degrees by using
\f2DsSetAngleUnits <DSSAU>\fP to set
\f2DcAngleDegrees <DCAD>\fP.
.SH ERRORS
\f2DoLightSpreadAngles\fP will fail if \f2delta_angle\fP is greater
than \f2total_angle\fP or less then zero, or if \f2total_angle\fP
is less than zero.
.TP 15
[WARNING - value out of range]
.SH DEFAULTS
The default value for \f2DoLightSpreadAngles\fP is  (pi/4, 0).
.SH SEE ALSO
.na
.nh
DoLightAttenuation(3D),
DoLightSpreadExp(3D), DoLightType(3D), 
DsInqAngleUnits(3D), DsSetAngleUnits(3D)
.ad
.hy
