.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DoLineList 3D  "Dore"
.SH NAME
DoLineList \- Create a line list primitive object
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
DtObject DoLineList(colormodel, vertextype, linecount, 
		vertices)
DtColorModel colormodel;
DtVertexType vertextype;
DtInt linecount;
DtReal vertices[\|];
.sp
.in -.5i
FORTRAN:
.in +.5i
INTEGER*4 DOLINL(COLMOD, VTXTYP, LINCNT, 
		VTXS)
INTEGER*4 COLMOD
INTEGER*4 VTXTYP
INTEGER*4 LINCNT
REAL*8 VTXS(*)
.in -.5i
.fi
.SH DESCRIPTION
.IX DOLINL
.IX DoLineList
.I DoLineList
creates a primitive object that defines a list of independent lines.
The parameter \f2colormodel\fP specifies the color model to be used when
defining vertex colors (if any).
The parameter \f2vertextype\fP specifies the exact nature of the vertex:
whether the vertex contains color, normal, or \f2uv/uvw\fP 
information for shading and texture mapping.
for more information, refer to Chapter 6, \f2\Dore Vertex Types\fP,
in the \f2\Dore Reference Manual\fP or to the on-line manual page
\f2VertexTypes\fP.)
The parameter \f2linecount\fP contains the number 
of lines in the list.
The parameter \f2vertices\fP is an array of three 
dimensional vertices
containing data for 2*\f2linecount\fP vertices.
When rendered, the \f2DoLineList\fP primitive object uses
the \f2DoLineWidth\fP <\f2DOLW\fP> and \f2DoLineType\fP <\f2DOLNT\fP> 
primitive attributes to determine the current line width and style.
.SH "SEE ALSO"
.na
.nh
DoLineType(3D), DoLineWidth(3D), DoLineType(3D), DoPolyline(3D),
VertexTypes(3D)
.ad
.hy
