.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DoLookAtFrom 3D  "Dore"
.SH NAME
DoLookAtFrom \- Create an orienting geometric transformation object
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
DtObject DoLookAtFrom(at, from, up)
DtPoint3 at, from;
DtVector3 up;
.sp
.in -.5i
FORTRAN:
.in +.5i
INTEGER*4 DOLAF(AT, FROM, UP)
REAL*8 AT(3), FROM(3)
REAL*8 UP(3)
.in -.5i
.fi
.IX  DoLookAtFrom
.IX  DOLAF
.SH DESCRIPTION
\f2DoLookAtFrom\fP creates a geometric transformation object
that modifies the current transformation matrix.
\f2DoLookAtFrom\fP specifies a modeling transformation that combines
a translation and a series of rotations.
.PP
The parameter \f2from\fP specifies the position of the new origin.
The ray between \f2at\fP and \f2from\fP specifies the new Z-direction.
The new XY-plane will be the plane which is
perpendicular to the new Z-direction and which
includes the new origin.
.PP
The parameter \f2up\fP specifies the new Y-direction as the projection of the
\f2up\fP vector onto the new XY-plane.
The new X-direction is computed such that the new X-, Y-, and
Z-directions define a right-handed coordinate system.
.PP
\f2DoLookAtFrom\fP commonly specifies the position, direction of gaze,
and the up direction of light and camera objects in a definition group.
It may also be used to orient primitive objects within a scene.
.SH ERRORS
The results of \f2DoLookAtFrom\fP are undefined if
.IP
The \f2at\fP and \f2from\fP points lie in a line parallel to
the \f2up\fP vector.
.IP
The \f2at\fP and \f2from\fP points are identical.
.IP
The \f2up\fP vector is of 0 length.
.TP 15
[WARNING - degenerate lookatfrom specification]
.SH "SEE ALSO"
.na
.nh
DoCamera(3D), DoLight(3D),
DoRotate(3D), DoScale(3D), DoShear(3D), DoTransformMatrix(3D), DoTranslate(3D)
.ad
.hy
