.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DoMatrix 3D  "Dore"
.SH NAME
DoMatrix \- Create a matrix object
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
DtObject DoMatrix(n,m,data)
DtInt n, m;
DtReal data[\|];
.sp
.in -.5i
FORTRAN:
.in +.5i
INTEGER*4 DOM(N, M, DATA)
INTEGER*4 N, M
REAL*8 DATA(M, N)
.in -.5i
.fi
.SH DESCRIPTION
.IX DOM
.IX DoMatrix
\f2DoMatrix\fP creates a matrix object.  The object represents an
\f2n\fP by \f2m\fP matrix, with values given in the \f2data\fP array
argument.  Matrix objects are useful as arguments to the 
\f2DoPatch\fP <\f2DOPAT\fP> routine.
Dor\o.\(aae. provides a number of standard matrices, including:
.nf

	\f2DcBezier4\fP <\f2DCMXB4\fP> - cubic Bezier patch basis.
	\f2DcHermite4\fP <\f2DCMXH4\fP> - cubic Hermite patch basis.
	\f2DcBSpline4\fP <\f2DCMXBS\fP> - cubic BSpline patch basis.

.fi
.SH ERRORS
.I DoMatrix
will fail if \f2n\fP or \f2m\fP is greater than 20.
.TP 15
[WARNING - value out of range]
.SH "SEE ALSO"
DoPatch(3D)
..

