.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DoPushAtts 3D  "Dore"
.SH NAME
DoPushAtts \- Create an organizational object that pushes all attributes 
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
DtObject DoPushAtts()
.sp
.in -.5i
FORTRAN:
.in +.5i
INTEGER*4 DOPUA()
.in -.5i
.fi
.SH DESCRIPTION
.IX DOPUA
.IX DoPushAtts
\f2DoPushAtts\fP creates an organizational object that pushes all
attributes.  This object saves the local environment of all
attributes; the environment is restored with \f2DoPopAtts\fP <\f2DOPPA\fP>.
.PP
\f2DoPushAtts\fP and \f2DoPopAtts\fP <\f2DOPPA\fP> act as a team to
create a local environment of attributes that may be saved and restored.
\f2DoPushAtts\fP effectively pushes onto a local stack any attributes
that could be
modified by objects between its location in the regular group and a
subsequent \f2DoPopAtts\fP object.
Execution of the \f2DoPopAtts\fP <\f2DOPPA\fP> object restores
the values from the stack of all attributes values that were pushed.
\f2DoPushAtts\fP and \f2DoPopAtts\fP
<\f2DOPPA\fP> objects may be nested; however, \f2DoPushAtts\fP and
\f2DoPopAtts\fP <\f2DOPPA\fP> will not work across group boundaries.
.PP
During execution, regular groups act as if they performed a
\f2DoPushAtts\fP before their execution starts and a
\f2DoPopAtts\fP <\f2DOPPA\fP> when they are exited.
Inline groups behave differently; see \f2DoInLineGroup\fP.
When a group is closed, all \f2DoPushAtts\fP still in effect
are popped.
.SH "SEE ALSO"
.na
.nh
DoGroup(3D), DoInLineGroup(3D), DoPopAtts(3D), DoPopMatrix(3D),
DoPushMatrix(3D)
.hy
.ad
