.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DoQuadGrid 3D  "Dore"
.SH NAME
DoQuadGrid \- Create a quadrilateral grid primitive object
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
DtObject DoQuadGrid(colormodel, vertextype, width, height, 
			vertices, smoothflag)
DtColorModel colormodel;
DtVertexType vertextype;
DtInt width;
DtInt height;
DtReal vertices[\|];
DtFlag smoothflag;
.sp
.in -.5i
FORTRAN:
.in +.5i
INTEGER*4 DOQUDG(COLMOD, VTXTYP, WIDTH,
			HEIGHT, VTXS, SMOOFL)
INTEGER*4 COLMOD
INTEGER*4 VTXTYP
INTEGER*4 WIDTH
INTEGER*4 HEIGHT
REAL*8 VTXS(*)
INTEGER*4 SMOOFL
.in -.5i
.fi
.SH DESCRIPTION
.IX DOQUDG
.IX DoQuadGrid
.I DoQuadGrid
creates a primitive object that defines a grid of (\f2width\fP-1) by
(\f2height\fP-1) quadrilaterals.
The parameter \f2colormodel\fP specifies the color model used if the vertices
contain color information for shading.
The parameter \f2vertextype\fP specifies the exact nature of the vertices.
For more information, refer to Chapter 6, \f2Dore Vertex Types\fP,
in the \f2Dore Reference Manual\fP or 
to the \f2VertexTypes\fP on-line manual page.)
The parameter \f2vertices\fP is an array of vertex data.
It must contain data for \f2width*height\fP vertices.
Starting from the upper left corner,
the first \f2width\fP vertices specify the top edges of the grid.
Each subsequent group of \f2width\fP vertices specifies the
next row of vertices for the grid.
.PP
The geometric normal to each quadrilateral is calculated using the right-hand rule
(when the fingers of the right hand point in the order of the vertices, 
the thumb points in the direction of the normal).  These geometric normal 
calculations require that all quadrilaterals be planar.
Dore uses these normals for backface culling and flat shading.
.SH "SEE ALSO"
DoQuadMesh(3D), DoQuadList, VertexTypes(3D)
