.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DoQuadList 3D  "Dore"
.SH NAME
DoQuadList \- Create a quadrilateral list primitive object
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
DtObject DoQuadList(colormodel, vertextype, 
		quadcount, vertices)
DtColorModel colormodel;
DtVertexType vertextype;
DtInt quadcount;
DtReal vertices[\|];
.sp
.in -.5i
FORTRAN:
.in +.5i
INTEGER*4 DOQUDL(COLMOD, VTXTYP, QUDCNT, 
		VTXS)
INTEGER*4 COLMOD
INTEGER*4 VTXTYP
INTEGER*4 QUDCNT
REAL*8 VTXS(*)
.in -.5i
.fi
.SH DESCRIPTION
.IX DOQUDL
.IX DoQuadList
.I DoQuadList
creates a primitive object that defines a list of independent quadrilaterals.
The parameter \f2colormodel\fP specifies the color model used if the vertices
contain color information for shading.
The parameter \f2vertextype\fP specifies the exact nature of the vertices.
For more information, refer to Chapter 6, \f2Dore Vertex Types\fP,
in the \f2Dore Reference Manual\fP or 
to the \f2VertexTypes\fP on-line manual page.)
The parameter \f2vertices\fP is an array of vertex data.
It must contain data for 4*\f2quadcount\fP vertices.
.PP
The geometric normal to each quadrilateral is calculated using the right-hand rule
(when the fingers of the right hand point in the order of the vertices, 
the thumb points in the direction of the normal).  These geometric normal 
calculations require that all quadrilaterals be planar.
Dore uses these normals for backface culling and flat shading.
.SH "SEE ALSO"
DoQuadMesh(3D), VertexTypes(3D)
