.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DoRefractionIndex 3D "Dore"
.SH NAME
DoRefractionIndex \- Create a refraction index primitive attribute object 
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
DtObject DoRefractionIndex(index)
DtReal index;
.sp
.in  -.5i
FORTRAN:
.in  +.5i
INTEGER*4 DORFRI(INDEX)
REAL*8 INDEX
.in  -.5i
.fi 
.IX "DoRefractionIndex"
.IX "DORFRI"
.SH DESCRIPTION
.LP
\f2DoRefractionIndex\fP creates a refraction index primitive 
attribute object. 
.LP
When light passes from one material to another the path of the light
ray is altered by refraction.
This can be seen, for example, when light passes from air to a
transparent material, such as glass or water.
.LP
How much a light ray is bent when it passes from one material to 
another depends on the ratio of the indices of refraction for 
the two materials.
The parameter \f2index\fP is an index of refraction to be used 
for all subsequent primitive objects.
.LP
A primitive object will refract light rays only if the 
\f2DoRefractionSwitch\fP <\f2DORFRS\fP>
and the \f2DoTranspSwitch\fP <\f2DOTS>\fP> are
enabled.
.SH DEFAULTS
The default \f2DoRefractionIndex\fP is 1.0. 
.SH SEE ALSO 
.na
.nh
DoRefractionSwitch(3D), DoTranspSwitch(3D)
.ad
.hy
\&
