.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DoSubDivSpec 3D  "Dore"
.SH NAME
DoSubDivSpec \- Create a subdivision specification primitive attribute object
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
DtObject DoSubDivSpec(type,parms)
DtInt type;
DtReal parms[\|];
.sp
.in -.5i
FORTRAN:
.in +.5i
INTEGER*4 DOSDS(TYPE,PARMS)
INTEGER*4 TYPE
REAL*8 PARMS(*)
.in -.5i
.fi
.SH DESCRIPTION
.IX DOSDS
.IX DoSubDivSpec
.I DoSubDivSpec
creates a subdivision specification primitive attribute object.
\f2DoSubDivSpec\fP specifies how to subdivide subsequent
analytic primitive objects.
.PP
Some primitive objects, such as spheres,
cylinders, tori, and patches, are \f2analytic objects\fP.
That is, they are described by an equation rather than a set of data.
.PP
For rendering, these objects must sometimes be decomposed into 
smaller elements, for example, triangles.
These smaller elements 
are \f2approximations\fP of the original analytic
surfaces.  The finer the decomposition of these surfaces, the closer
they approximate the actual object.
.PP
The argument \f2type\fP can be one of the following:
.IP "\f2DcSubDivFixed\fP <\f2DCSDFX\fP>"
For this type, the number of segments along an edge will be
equal to 2 to the power of (\f2parms[0]-1\fP).
.IP "\f2DcSubDivSegments\fP <\f2DCSDSG\fP>"
For this type, the number of segments along an edge will be equal to
\f2parms[0]\fP whenever possible.  When this is not possible, the
number of segments along an edge will be as close to \f2parms[0]\fP
as possible, depending on the primitive being subdivided.
.IP "\f2DcSubDivAbsolute\fP <\f2DCSDAB\fP>"
For this type, \f2parms[0]\fP equals the maximum deviation
allowed anywhere between the curved surface and the nearest plane
in the planar approximation of the object. 
.IP "\f2DcSubDivRelative\fP <\f2DCSDRL\fP>"
For this type, \f2parms[0]\fP equals the ratio of the deviation
to the length of the side of the approximating polygon.
In general,
specifying a deviation between 1.5 percent and 4 percent for
relative subdivision will result in a reasonable representation
of many objects.
.SH DEFAULTS
The default values for \f2DoSubDivSpec\fP are \f2DcSubDivRelative\fP
<\f2DCSDRL\fP> with a \%\f2parms[0]\fP value of 0.1.
.SH "SEE ALSO"
.na
.nh
DoPatch(3D), DoPrimSurf(3D), DoSphereList(3D), DoTorus(3D)
.ad
.hy
