.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DoTextFont 3D  "Dore"
.SH NAME
DoTextFont \- Create a text font primitive attribute object
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
DtObject DoTextFont(font)
DtFont font;
.sp
.in -.5i
FORTRAN:
.in +.5i
INTEGER*4 DOTF(FONT)
INTEGER*4 FONT
.in -.5i
.fi
.SH DESCRIPTION
.IX DOTF
.IX DoTextFont
.I DoTextFont
creates a text font primitive attribute object. The parameter \f2font\fP 
defines the font to be used for subsequently executed text primitive
objects.
The Dore fonts are:
.PP
.nh
.na
.nf
.ta 2.5i 1.5i
FORTRAN Font Name
.sp
DcAstrology 			<DCFAST>
DcComplexCyrillic 		<DCFCC>
DcComplexGreek 			<DCFCG>
DcComplexSmallGreek 		<DCFCSG>
DcComplexSmallItalic 		<DCFCSI>
DcComplexSmallRoman 		<DCFCSR>
DcComplexItalic			<DCFCI>
DcComplexRoman			<DCFCR>
DcComplexScript			<DCFCS>
DcDuplexRoman			<DCFDR>
DcLowerCaseMathematics 		<DCFLCM>
DcGothicGerman			<DCFGG>
DcGothicEnglish			<DCFGE>
DcGothicItalian			<DCFGI>
DcHelvetica (polygonal font) 		<DCFHLV>
DcMusic				<DCFMUS>
DcMeteorology 			<DCFMUS>
DcPlainGreek 			<DCFPG>
DcPlainRoman 			<DCFPR>
DcSimplexRoman			<DCFSR>
DcSimplexGreek			<DCFSG>
DcSimplexScript			<DCFSS>
DcSymbols 			<DCFSYM>
DcTriplexItalic			<DCFTI>
DcTriplexRoman			<DCFTR>
DcUpperCaseMathematics 		<DCFUCM>
.re
.ad
.hy
.fi
.SH DEFAULTS
The default \f2DoTextFont\fP is \f2DcPlainRoman\fP <\f2DCFPR\fP>.
.SH ERRORS
.I DoTextFont
will fail if an invalid \f2font\fP is specified.
.TP 15
[WARNING - value out of range]
.PP
.I DoTextFont
will fail if memory cannot be allocated for character storage.
.TP 15
[SEVERE - unable to allocate memory]
.SH "SEE ALSO"
.na
.nh
DoAnnoText(3D), DoText(3D), DoTextAlign(3D), DoTextExpFactor(3D), 
DoTextHeight(3D), DoTextPath(3D), DoTextPrecision(3D), DoTextSpace(3D),
DoTextUpVector(3D)
.ad
.hy
