.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DoTextureMatrixUV 3D "Dore"
.SH NAME
DoTextureMatrixUV \- Create a texture attribute object that sets the texture matrix for primitive \f2uv\fP coordinates
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
DtObject DoTextureMatrixUV(matrix)
DtMatrix3x3 matrix;
.sp
.in  -.5i
FORTRAN:
.in  +.5i
INTEGER*4 DOTMUV(MATRIX)
REAL*8 MATRIX(3,3)
.in  -.5i
.fi 
.IX "DoTextureMatrixUV"
.IX "DOTMUV"
.SH DESCRIPTION
.LP
\f2DoTextureMatrixUV\fP creates a texture attribute object that 
defines the transformation values to be applied to a primitive 
object's \f2uv\fP coordinates before they are used to access a
2-dimensional texture.  The argument \f2matrix\fP is an arbitrary 
3x3 matrix that becomes the texture matrix.  
.LP
The scale and translate components of the texture matrix can
be individually altered using \f2DoTextureScaleUV <DOTSUV>\f1 and 
\f2DoTextureTranslateUV <DOTTUV\fP>, respectively.  However, 
because \f2DoTextureScaleUV\f1 may alter any rotations previously stored 
in the texture matrix, it is recommended that either \f2DoTextureMatrixUV\f1 
alone or \f2DoTextureScaleUV/DoTextureTranslateUV\f1 be used.
.SH DEFAULTS
The default value for \f2DoTextureMatrixUV\fP is a 3x3 identity matrix.
.SH SEE ALSO
.na
.nh
DoTextureMapDiffuseColor(3D),
DoTextureMapEnviron(3D),
DoTextureMapBump(3D),
DoTextureMapTranspIntens(3D),
DoTextureMatrixUVW(3D),
DoTextureScaleUV(3D),
DoTextureTranslateUV(3D)
.ad
.hy
\&
