.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DoTorus 3D  "Dore"
.SH NAME
DoTorus \- Create a torus primitive object
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
DtObject DoTorus(bigradius, xsectionradius)
DtReal bigradius;
DtReal xsectionradius;
.sp
.in -.5i
FORTRAN:
.in +.5i
INTEGER*4 DOTOR(BIGRAD, XRAD)
REAL*8 BIGRAD
REAL*8 XRAD
.in -.5i
.fi
.SH DESCRIPTION
.IX DOTOR
.IX DoTorus
.I DoTorus
creates a torus (donut-shaped) primitive object.  The parameter
\f2bigradius\fP specifies the distance from the center
(within the hole) of the torus to the center of the ring.  The parameter
\f2xsectionradius\fP specifies the radius of the cross-section
of the ring itself.  The torus is centered at the origin and the 
perimeter of the large circle is in the XZ-plane.
.SH "SEE ALSO"
DoSubDivSpec(3D)
