.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DoTranspOrientExp 3D "Dore"
.SH NAME
DoTranspOrientExp \- Create a transparent exponent primitive attribute object for orientation dependent transparency
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
DtObject DoTranspOrientExp(exponent)
DtReal exponent;
.sp
.in  -.5i
FORTRAN:
.in  +.5i
INTEGER*4 DOTOE(EXP)
REAL*8 EXP
.in  -.5i
.fi 
.IX "DoTranspOrientExp"
.IX "DOTOE"
.SH DESCRIPTION
.PP
\f2DoTranspOrientExp\fP creates a transparent exponent primitive attribute 
object for orientation dependent transparency.
.PP
Orientation dependent transparency means that the transparency of
an object varies depending on the orientation of the object and the 
view direction.
The transparency can also vary across the object if it is not 
completely flat.
.PP
The parameter \f2exponent\fP specifies the transparent exponent 
to be used for subsequent objects when the object is oriented so that
the object normal is neither perpendicular nor parallel 
to the viewing direction.
See \f2DoTranspOrientColor\fP and \f2DoTranspOrientIntens\fP for 
details of the formulas that use the transparent exponent.
.PP
To enable orientation dependent transparency, both 
.nh
\f2DoTranspOrientSwitch\fP
.hy
\f2<DOTOS>\fP and 
.nh
\f2DoTranspSwitch\fP
.hy
\f2<DOTS>\fP
must be turned on.
.SH DEFAULTS
The default \f2DoTranspOrientExp\fP is 1.0.
.SH SEE ALSO 
.nh
.na
DoTranspOrientSwitch(3D),
DoTranspOrientColor(3D),
DoTranspOrientIntens(3D),
DoTranspColor(3D),
DoTranspIntens(3D),
DoTranspSwitch(3D)
.hy
.ad
\&
