.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DoVarTriangleStrip 3D  "Dore"
.SH NAME
DoVarTriangleStrip \- Create a variable triangle strip primitive object
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
DtObject DoVarTriangleStrip(colormodel, vertexcount, 
		vertlocs, vertnorms, vertcolors)
DtColorModel colormodel;
DtInt vertexcount;
DtReal vertlocs[\|];
DtReal vertnorms[\|];
DtReal vertcolors[\|];
.sp
.in -.5i
FORTRAN:
.in +.5i
INTEGER*4 DOVTRS(COLMOD, VTXCNT, VTXLOC, 
		VTXNRM, VTXCLR)
INTEGER*4 COLMOD
INTEGER*4 VTXCNT
REAL*8 VTXLOC(*)
REAL*8 VTXNRM(*)
REAL*8 VTXCLR(*)
.fi
.SH DESCRIPTION 
.IX DOVTRS
.IX DoVarTriangleStrip
.I DoVarTriangleStrip 
creates a primitive object that defines a variable
strip of connected triangles.
.PP
The main difference between a variable triangle strip and a triangle 
strip is that a variable triangle strip does not make a copy of the 
vertex data into its own data space.  
It simply maintains pointers to the vertex data 
(locations, normals and colors) in user space.  
A call to \f2DpUpdVarTriangleStrip\fP <\f2DPUVTS\fP> informs a 
variable triangle strip object that the user data has changed.
.PP
The parameter \f2colormodel\fP specifies the color model used if 
vertex colors are provided.
.PP
The parameter \f2vertexcount\fP specifies the total number of 
vertices in the strip.
The first three vertices make up the first triangle.
Each additional vertex adds an additional triangle.
This means that the number of triangles drawn is
two less than the number of vertices.
.PP
The parameter \f2vertlocs\fP is an array of vertex locations.
The parameter \f2vertnorms\fP is an array of vertex normals.
If vertex normals are not available use
\f2DcNullPtr\fP <\f2DCNULL\fP>.
The parameter \f2vertcolors\fP is an array of vertex colors. 
If vertex colors are not available use
\f2DcNullPtr\fP <\f2DCNULL\fP>.
.PP
The geometric normal to each triangle is calculated using the right-hand 
rule (when the fingers of the right hand point in the order of the 
vertices, the thumb points in the direction of the normal) for triangles
1, 3, 5, etc.  
The left-hand rule is used for triangle 2, 4, 6, etc.
.SH ERRORS
\f2DoVarTriangleStrip\fP must be called with at least three vertices.
.TP 15
[WARNING - invalid parameter]
.SH "SEE ALSO"
.na
.nh
DoTriangleStrip(3D),
DoVarLineList(3D),
DoVarPointList(3D),
DoVarSimplePolygonMesh(3D),
DoVarTriangleMesh(3D),
DpUpdVarTriangleStrip(3D) 


.ad
.hy
