.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DoView 3D  "Dore"
.SH NAME
DoView \- Create a view organizational object
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
DtObject DoView()
.sp
.in -.5i
FORTRAN:
.in +.5i
INTEGER*4 DOVW()
.in -.5i
.fi
.SH DESCRIPTION
.IX DOVW
.IX DoView
.I DoView
creates a new view.  A view is an organizational object that describes
a scene.
.PP
A view contains a display group and a definition group.
The display group contains all of the objects to be displayed when the view is
updated.  The definition group contains the cameras that view the
scene and the lights that illuminate it.
In addition, views also contain attributes that affect aspects of
the final images.  These aspects are:
.IP
The active camera, one of the cameras in the definition group.
.IP
The background color.
.IP
The clear flag, whether to clear to background before rendering.
.IP
The render style.
.IP
The view boundary, in frame coordinates.
.SH "SEE ALSO"
.na
.nh
DvInqDefinitionGroup(3D), DvInqDisplayGroup(3D), DvSetActiveCamera(3D),
DvSetBackgroundColor(3D), DvSetClearFlag(3D), DvSetRendStyle(3D),
DvSetBoundary(3D), DvUpdate(3D)
.ad
.hy
