.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DsExecuteObj 3D  "Dore"
.SH NAME
DsExecuteObj \- Execute an object immediately
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
void DsExecuteObj(object)
DtObject object;
.sp
.in -.5i
FORTRAN:
.in +.5i
CALL DSEO(OBJECT)
INTEGER*4 OBJECT
.in -.5i
.fi
.SH DESCRIPTION
.IX DSEO
.IX DsExecuteObj
.I DsExecuteObj
causes the immediate execution of an object.
This functionality provides true conditional execution by 
creating callback objects that affect
group traversal by choosing which objects (sub-trees) to execute. 
.PP
Objects executed by callbacks are executed with the same method with
which the callback was executed.
.SH ERRORS
.I DsExecuteObj
will fail if passed an invalid object.
.TP 15
[WARNING - invalid or deleted object]
.PP
.I DsExecuteObj
will fail if no traversal of the database is in progress.
.TP 15
[WARNING - no traversal in progress]
.SH "SEE ALSO"
DoCallback(3D)
