.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DsInqHoldObj 3D  "Dore"
.SH NAME
DsInqHoldObj \- Return whether a hold has been placed on the object
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
DtFlag DsInqHoldObj(object)
DtObject object;
.sp
.in -.5i
FORTRAN:
.in +.5i
INTEGER*4 DSQHO(OBJECT)
INTEGER*4 OBJECT
.in -.5i
.fi
.SH DESCRIPTION
.IX DSQHO
.IX DsInqHoldObj
\f2DsInqHoldObj\fP returns whether a hold has been placed on the
object specified by the parameter \f2object\fP.  See \f2DsHoldObj\fP for
details on hold objects.
.SH ERRORS
\f2DsInqHoldObj\fP will fail if passed an invalid object; the returned value is
undefined.
.TP 15
[WARNING - invalid or deleted object]
.SH "SEE ALSO"
DsHoldObj(3D), DsReleaseObj(3D)
