.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DsInqObjNameString 3D  "Dore"
.SH NAME
DsInqObjNameString \- Return the name of a string-named object
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
char* DsInqObjNameString (object)
.in  +.5i
DtObject object;
.in  -.5i
FORTRAN:
.in +.5i
CALL DSQONS(OBJECT, FNAME, LENGTH)
INTEGER*4 OBJECT
INTEGER*4 LENGTH
CHARACTER*LENGTH FNAME
.in  -.5i
.fi
.SH DESCRIPTION
.IX DsInqObjNameString
.I DsInqObjNameString
returns the string name of the object.  If the object has no string-valued
name, the function will return null, otherwise it returns a pointer to the
character string specified via the \f2DsSetObjNameString\fP function.
.PP
The parameter \f2object\fP specifies the object that is queried.
.SH "FORTRAN SPECIFIC"
.PP
.I DSQONS
returns the name of the object \f2OBJECT\fP.  This function
should be used when the object name is of type \f2DCNSTR\fP (it's a string).
The string name is returned in \f2FNAME\fP and is \f2LENGTH\fP characters long.
.SH ERRORS
.I DsInqObjNameString
will fail if the object is invalid.
.TP 15
[WARNING - invalid or deleted object]
.SH "SEE ALSO"
.nf
DsInqObjNameType(3D), DsInqObjNameInteger(3D),
DsInqObjViaInteger(3D), DsInqObjViaString(3D),
DsSetObjNameInteger(3D), DsSetObjNameString(3D)
