.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DsInqRendererNames 3D "Dore"
.SH NAME
DsInqRendererNames \- Return a list of the names of the installed renderers
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
void DsInqRendererNames(names)
DtPtr names[\|];
.sp
.in  -.5i
FORTRAN:
.in  +.5i
DSQRNS(NAMES, LENGTH)
CHARACTER NAMES(*)*LENGTH
INTEGER*4 LENGTH
.in  -.5i
.fi 
.IX "DsInqRendererNames"
.IX "DSQRNS"
.SH DESCRIPTION
.LP
\f2DsInqRendererNames\fP returns in the array \f2names\fP the names of
the available renderers in the current Dore system.
The array \f2names\fP is assumed to be long enough to
contain the complete list.
\f2DsInqNumRenderers\fP <\f2DSQNR\fP> returns the number of renderers
and should be used to determine the necessary size of the array \f2names\fP.
.PP
For example, in C you can dynamically allocate the
necessary space:

.nf
.in  +.5i
DtPtr *names;
DtInt cnt;
cnt = DsInqNumRenderers();
names = (DtPtr *)malloc(cnt*sizeof(DtPtr));
DsInqRendererNames(names);
.in  -.5i
.fi
.PP
FORTRAN, you can check to see if you have allocated
enough space:

.nf
.in  +.5i
CHARACTER*80 NAMES(10)
INTEGER*4 CNT
CNT = DSQNR( )
IF (CNT .GT. 10)
	WRITE (6,*)'more than 10 renderers'
ELSE
	DSQRNS(NAMES,80)
ENDIF
.in  -.5i
.fi
.SH FORTRAN SPECIFIC
The parameter \f2LENGTH\fP specifies the length of each of the
character arrays passed to \f2DSQRNS\fP.
Renderer names that are longer than \f2LENGTH\fP will be truncated to
fit in the specified size.
.SH SEE ALSO
.na
DsInqNumRenderers(3D)
.ad
