.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DsInqSafeFlag 3D  "Dore"
.SH NAME
DsInqSafeFlag \- Query the safe flag
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
DtFlag DsInqSafeFlag()
.sp
.in -.5i
FORTRAN:
.in +.5i
INTEGER*4 DSQSF()
.in -.5i
.fi
.SH DESCRIPTION
.IX DSQSF
.IX DsInqSafeFlag
.I DsInqSafeFlag
queries the safe flag.  The safe flag is a debugging tool for the 
application programmer.  
.PP
When the safe flag is set to \f2DcTrue\fP 
<\f2DCTRUE\fP>, all deleted objects are treated so that any private data 
associated with the object is released as usual but the 
type of object
is set to \f2DcObjectDeleted\fP <\f2DCODEL\fP>.
Whenever such an object is accessed, an error is generated and the user
can determine why the illegal reference was made.
.PP
If the flag is set to \f2DcFalse\fP <\f2DCFALS\fP>, 
both the object header and any private data of
all deleted objects are freed immediately.
If the safe flag is changed from \f2DcTrue\fP
<\f2DCTRUE\fP> to \f2DcFalse\fP <\f2DCFALS\fP>, 
all object headers of type \f2DcObjectDeleted\fP <\f2DCODEL\fP> are freed.
.PP
An application should not refer to an object's handle once the application
has released the object using \f2DsReleaseObj\fP <\f2DSRO\fP>.
.SH "SEE ALSO"
DsSetSafeFlag(3D), DsReleaseObj(3D)
