.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DsSetExeDepthLimit 3D  "Dore"
.SH NAME
DsSetExeDepthLimit \- Specify the maximum allowed depth to which objects will be executed
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
void DsSetExeDepthLimit(limit)
DtInt limit ;
.sp
.in -.5i
FORTRAN:
.in +.5i
CALL DSSEDL(LIMIT)
INTEGER*4 LIMIT 
.in -.5i
.fi
.SH DESCRIPTION
.IX DSSEDL
.IX DsSetExeDepthLimit
.I DsSetExeDepthLimit
is used to set the maximum allowed object execution depth, i.e.,
the number of descending generations a parent object may have.
The parameter \f2limit\fP is the depth in generations.
.SH ERRORS
.I DsSetExeDepthLimit
will fail if the execution limit is less than or equal to 0.
.TP 15
[WARNING - value out of range]
.SH DEFAULTS
The default execution depth limit is 20.
.SH "SEE ALSO"
DsInqExeDepthLimit(3D)
