.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DvInqBackgroundRaster 3D "Dore"
.SH NAME
DvInqBackgroundRaster \- Return the raster object and callback for a view background
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
void DvInqBackgroundRaster(view, raster, callback)
DtObject view;
DtObject *raster;
DtObject *callback;
.sp
.in  -.5i
FORTRAN:
.in  +.5i
CALL DVQBR(VIEW, RASTER, CBACK)
INTEGER*4 VIEW
INTEGER*4 RASTER
INTEGER*4 CBACK
.in  -.5i
.fi 
.IX "DvInqBackgroundRaster"
.IX "DVQBR"
.SH DESCRIPTION
.LP
\f2DvInqBackgroundRaster\fP inquires the current background raster
and callback associated with the view \f2view\fP.
.SH ERRORS
\f2DvInqBackgroundRaster\fP will fail if the view handle is invalid.
.TP 15
[WARNING - invalid view handle]
.SH SEE ALSO
.na
.nh
DvSetBackgroundJust(3D), DvInqBackgroundJust(3D), DvSetBackgroundRaster(3D),
DsInqRaster(3D)
.ad
.hy
\&
