.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DvInqClearFlag 3D  "Dore"
.SH NAME
DvInqClearFlag \- Return the clear flag of a view
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
DtFlag DvInqClearFlag(view)
DtObject view ;
.sp
.in -.5i
FORTRAN:
.in +.5i
INTEGER*4 DVQCF(VIEW)
INTEGER*4 VIEW 
.in -.5i
.fi
.SH DESCRIPTION
.IX DVQCF
.IX DvInqClearFlag
.I DvInqClearFlag
returns the value of \f2clearflag\fP for the view specified by 
the parameter \f2view\fP.
If \f2DcTrue\fP <\f2DCTRUE\fP> is returned,
the view is cleared to its background color or raster
every time the view is updated.  If \f2DcFalse\fP <\f2DCFALS\fP> is returned,
the view is not cleared.
.SH ERRORS
.I DvInqClearFlag
will fail if the view handle is invalid.
.TP 15
[WARNING - invalid view handle]
.SH "SEE ALSO"
DvSetClearFlag(3D)
