.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DvInqDisplayGroup 3D  "Dore"
.SH NAME
DvInqDisplayGroup \- Return the handle for a view's display group
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
DtObject DvInqDisplayGroup(view)
DtObject view;
.sp
.in -.5i
FORTRAN:
.in +.5i
INTEGER*4 DVQIG(VIEW)
INTEGER*4 VIEW
.in -.5i
.fi
.SH DESCRIPTION
.IX DVQIG
.IX DvInqDisplayGroup
.I DvInqDisplayGroup
returns the handle for a display group of the view specified by the parameter
\f2view\fP.
The display group is the part of every view that contains the objects that
are to be displayed when the view is updated.
.PP
When a view is updated, all objects in its display group are executed in
order.
Users may edit the display group to arrange objects in the desired order of
execution.
.SH ERRORS
.I DvInqDisplayGroup
will fail if the view handle is invalid; the returned value is
\f2DcNullObject\fP <\f2DCNULL\fP>.
.TP 15
[WARNING - invalid view handle]
.SH "SEE ALSO"
.na
.nh
DfInqViewGroup(3D), DoView(3D),
DvInqDefinitionGroup(3D), DvUpdate(3D)
.ad
.hy
