.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DvSetBackgroundColor 3D  "Dore"
.SH NAME
DvSetBackgroundColor \- Set the background color of a view
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
void DvSetBackgroundColor(view, colormodel, color)
DtObject view ;
DtColorModel colormodel;
DtReal color[\|];
.sp
.in -.5i
FORTRAN:
.in +.5i
CALL DVSBC(VIEW, COLMOD, COLOR)
INTEGER*4 VIEW 
INTEGER*4 COLMOD
REAL*8 COLOR(*)
.in -.5i
.fi
.SH DESCRIPTION
.IX DVSBC
.IX DvSetBackgroundColor
.I DvSetBackgroundColor
sets the background color of the view, \f2view\fP.
The parameter \f2colormodel\fP specifies the color model used.
If the clear flag is set, the parameter \f2color\fP specifies 
the background color that appears whenever \f2view\fP 
is cleared and updated.
.SH ERRORS
.I DvSetBackgroundColor
will fail if the view handle is invalid.
.TP 15
[WARNING - invalid view handle]
.SH DEFAULTS
The default background color is (\f2DcRGB\fP, 0.0, 0.0, 0.0).
.SH "SEE ALSO"
DvInqBackgroundColor(3D),
DvSetClearFlag(3D)
