.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DvSetBackgroundRaster 3D "Dore"
.SH NAME
DvSetBackgroundRaster \- Set the raster object for a view background
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
void DvSetBackgroundRaster(view, raster, callback)
DtObject view;
DtObject raster;
DtObject callback;
.sp
.in  -.5i
FORTRAN:
.in  +.5i
CALL DVSBR(VIEW, RASTER, CBACK)
INTEGER*4 VIEW
INTEGER*4 RASTER
INTEGER*4 CBACK
.in  -.5i
.fi 
.IX "DvSetBackgroundRaster"
.IX "DVSBR"
.SH DESCRIPTION
.LP
\f2DvSetBackgroundRaster\fP sets the raster object \f2raster\fP to be
used as a background image of the view \f2view\fP.
If \f2raster\fP is \f2DcNullPtr\fP <DCNULL> then the background color
(set by \f2DvSetBackgroundColor <DVSBC>\fP) will be used.
The callback object \f2callback\fP will be called if the dimensions of
the raster are not the same as the dimensions of the view in device
coordinates.
The callback object returns a raster object to be used for the
dimensions of the view as mapped on the device.
See \f2DvSetBackgroundJust\fP for a description of how mismatches in
view and raster dimensions are handled.
.LP
The callback function is called with the standard callback parameter
\f2data\fP plus the 3 additional parameters, the raster object, the
width of the view in device coordinates, and the height of the view in
device coordinates.
The callback function should return a raster object.
The function in C should look like this:
.sp
.nf
.in  +.5i
DtObject my_callback(data, raster, width, height)
DtPtr data;		/* if \f2data\fP is a pointer to data */
Dt32Bits data;		/* if \f2data\fP is a value */
DtObject raster;
DtInt width;
DtInt height;
.in  -.5i
.fi
.sp
FORTRAN:
.sp
.nf
.in  +.5i
INTEGER*4 MYCBK(DATA, RASTER, WIDTH, HEIGHT)
INTEGER*4 DATA
INTEGER*4 RASTER
INTEGER*4 WIDTH
INTEGER*4 HEIGHT
.in  -.5i
.fi
.PP
Within the callback function the data of the raster can be obtained
via a call to \f2DsInqRaster <DSQR>\fP.
.SH ERRORS
\f2DvSetBackgroundRaster\fP will fail if the view handle is invalid.
.PP
[WARNING - invalid view handle]
.SH SEE ALSO
.na
.nh
DsInqRaster(3D),
DvInqBackgroundJust(3D), 
DvInqBackgroundRaster(3D),
DvSetBackgroundJust(3D)
.ad
.hy
\&
